
import gurobi

# Create a new model
model = gurobi.Model()

# Define variables
x0 = model.addVar(lb=0, name="hours_worked_by_Bill")  # Continuous variable for Bill
x1 = model.addVar(lb=0, vtype=gurobi.GRB.INTEGER, name="hours_worked_by_Jean")  # Integer variable for Jean

# Objective function: Maximize 7.94*x0 + 3.2*x1
model.setObjective(7.94*x0 + 3.2*x1, gurobi.GRB.MAXIMIZE)

# Constraints
model.addConstr(6*x0 + 12*x1 >= 15, name="total_cost_min")
model.addConstr(6*x0 + 12*x1 <= 42, name="total_cost_max")
model.addConstr(-6*x0 + 3*x1 >= 0, name="linear_constraint")

# Solve the model
model.optimize()

# Print solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Hours worked by Bill: {x0.varValue}")
    print(f"Hours worked by Jean: {x1.varValue}")
    print(f"Objective: {model.objVal}")
else:
    print("No optimal solution found.")
