
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("PlantOptimization")

# Create variables
chrysanthemums = m.addVar(vtype=GRB.INTEGER, name="chrysanthemums")
strawberry_bushes = m.addVar(vtype=GRB.INTEGER, name="strawberry_bushes")
decorative_cabbages = m.addVar(vtype=GRB.INTEGER, name="decorative_cabbages")
boxwoods = m.addVar(vtype=GRB.INTEGER, name="boxwoods")

# Set objective function
m.setObjective(8*chrysanthemums**2 + 6*chrysanthemums*strawberry_bushes + 4*chrysanthemums*decorative_cabbages + 6*strawberry_bushes*decorative_cabbages + 6*strawberry_bushes*boxwoods + 5*decorative_cabbages*boxwoods + boxwoods**2 + 5*chrysanthemums + 7*strawberry_bushes + 6*decorative_cabbages + boxwoods, GRB.MINIMIZE)

# Add constraints (converting sq ft to sq inches by multiplying by 144)
m.addConstr(18*chrysanthemums + 15*strawberry_bushes + 22*decorative_cabbages + 21*boxwoods <= 275, "Total Planting Space")
m.addConstr(18*chrysanthemums + 22*decorative_cabbages >= 68 * 144, "Chrysanthemums + Decorative Cabbages Space")
m.addConstr((18*chrysanthemums)**2 + (21*boxwoods)**2 >= 43 * 144**2, "Chrysanthemums^2 + Boxwoods^2 Space")
m.addConstr(15*strawberry_bushes + 21*boxwoods >= 54 * 144, "Strawberry Bushes + Boxwoods Space")
m.addConstr(18*chrysanthemums + 15*strawberry_bushes >= 46 * 144, "Chrysanthemums + Strawberry Bushes Space")
m.addConstr((22*decorative_cabbages)**2 + (21*boxwoods)**2 >= 63 * 144**2, "Decorative Cabbages^2 + Boxwoods^2 Space")
m.addConstr(18*chrysanthemums + 22*decorative_cabbages + 21*boxwoods >= 57 * 144, "Chrysanthemums + Decorative Cabbages + Boxwoods Space")
m.addConstr(15*strawberry_bushes + 22*decorative_cabbages + 21*boxwoods >= 57 * 144, "Strawberry Bushes + Decorative Cabbages + Boxwoods Space")
m.addConstr(18*chrysanthemums + 15*strawberry_bushes + 22*decorative_cabbages >= 57 * 144, "Chrysanthemums + Strawberry Bushes + Decorative Cabbages Space")
m.addConstr(18*chrysanthemums + 22*decorative_cabbages + 21*boxwoods >= 56 * 144, "Chrysanthemums + Decorative Cabbages + Boxwoods Space 2")
m.addConstr(15*strawberry_bushes + 22*decorative_cabbages + 21*boxwoods >= 56 * 144, "Strawberry Bushes + Decorative Cabbages + Boxwoods Space 2")
m.addConstr(18*chrysanthemums + 15*strawberry_bushes + 22*decorative_cabbages >= 56 * 144, "Chrysanthemums + Strawberry Bushes + Decorative Cabbages Space 2")
m.addConstr(18*chrysanthemums + 22*decorative_cabbages + 21*boxwoods >= 35 * 144, "Chrysanthemums + Decorative Cabbages + Boxwoods Space 3")
m.addConstr((15*strawberry_bushes)**2 + (22*decorative_cabbages)**2 + (21*boxwoods)**2 >= 35 * 144**2, "Strawberry Bushes^2 + Decorative Cabbages^2 + Boxwoods^2 Space")
m.addConstr(18*chrysanthemums + 15*strawberry_bushes + 22*decorative_cabbages >= 35 * 144, "Chrysanthemums + Strawberry Bushes + Decorative Cabbages Space 3")
m.addConstr(18*chrysanthemums + 15*strawberry_bushes + 22*decorative_cabbages + 21*boxwoods >= 35 * 144, "Total Plants Space")
m.addConstr(-7*chrysanthemums**2 - 4*decorative_cabbages**2 + 4*boxwoods**2 >= 0, "Squared Plants Constraint")
m.addConstr((15*strawberry_bushes)**2 + (22*decorative_cabbages)**2 <= 266 * 144**2, "Strawberry Bushes^2 + Decorative Cabbages^2 Space <= ")
m.addConstr((22*decorative_cabbages)**2 + (21*boxwoods)**2 <= 105 * 144**2, "Decorative Cabbages^2 + Boxwoods^2 Space <= ")
m.addConstr((18*chrysanthemums)**2 + (15*strawberry_bushes)**2 <= 218 * 144**2, "Chrysanthemums^2 + Strawberry Bushes^2 Space <= ")
m.addConstr(18*chrysanthemums + 15*strawberry_bushes + 22*decorative_cabbages <= 85 * 144, "Chrysanthemums + Strawberry Bushes + Decorative Cabbages Space <= ")
m.addConstr((15*strawberry_bushes)**2 + (22*decorative_cabbages)**2 + (21*boxwoods)**2 <= 130 * 144**2, "Strawberry Bushes^2 + Decorative Cabbages^2 + Boxwoods^2 Space <= ")
m.addConstr(18*chrysanthemums + 22*decorative_cabbages + 21*boxwoods <= 87 * 144, "Chrysanthemums + Decorative Cabbages + Boxwoods Space <= ")
m.addConstr((18*chrysanthemums)**2 + (15*strawberry_bushes)**2 + (21*boxwoods)**2 <= 96 * 144**2, "Chrysanthemums^2 + Strawberry Bushes^2 + Boxwoods^2 Space <= ")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

