
from gurobipy import Model, GRB

# Create a new model
m = Model("optimization_problem")

# Create variables
ringo_hours = m.addVar(vtype=GRB.INTEGER, name="ringo_hours")
laura_hours = m.addVar(vtype=GRB.CONTINUOUS, name="laura_hours")

# Set objective function
m.setObjective(9.58 * ringo_hours * ringo_hours + 1.36 * ringo_hours * laura_hours, GRB.MAXIMIZE)

# Add constraints
m.addConstr(2 * ringo_hours * ringo_hours + 12 * laura_hours * laura_hours >= 21, "computer_competence_lower")
m.addConstr(6 * ringo_hours + 12 * laura_hours >= 61, "organization_score_lower")
m.addConstr(8 * ringo_hours - 4 * laura_hours >= 0, "constraint_3")
m.addConstr(2 * ringo_hours * ringo_hours + 12 * laura_hours * laura_hours <= 46, "computer_competence_upper")
m.addConstr(2 * ringo_hours + 12 * laura_hours <= 46, "combined_computer_competence_upper")
m.addConstr(6 * ringo_hours * ringo_hours + 12 * laura_hours * laura_hours <= 139, "organization_score_upper")
m.addConstr(6 * ringo_hours + 12 * laura_hours <= 139, "combined_organization_score_upper")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('Ringo Hours:', ringo_hours.x)
    print('Laura Hours:', laura_hours.x)
elif m.status == GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

