
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x0 = m.addVar(vtype=GRB.INTEGER, name="hours_worked_by_Ringo")
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="hours_worked_by_Laura")

# Set the objective function
m.setObjective(9.58*x0**2 + 1.36*x0*x1, GRB.MAXIMIZE)

# Add constraints
m.addConstr(2*x0 <= 60, "Ringo_computer_rating")
m.addConstr(6*x0 <= 151, "Ringo_organization_score")
m.addConstr(12*x1 <= 60, "Laura_computer_rating")
m.addConstr(12*x1 <= 151, "Laura_organization_score")
m.addConstr(4*x0**2 + 144*x1**2 >= 21, "Combined_min_computer_rating")
m.addConstr(6*x0 + 12*x1 >= 61, "Combined_organization_score")
m.addConstr(8*x0 - 4*x1 >= 0, "Hours_worked_constraint")
m.addConstr(4*x0**2 + 144*x1**2 <= 46, "Max_combined_computer_rating_squared")
m.addConstr(2*x0 + 12*x1 <= 46, "Max_combined_computer_rating_linear")
m.addConstr(36*x0**2 + 144*x1**2 <= 139, "Max_combined_organization_score_squared")
m.addConstr(6*x0 + 12*x1 <= 139, "Max_combined_organization_score_linear")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Hours worked by Ringo: {x0.x}")
    print(f"Hours worked by Laura: {x1.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
