
import gurobi

# Create a new model
model = gurobi.Model()

# Define variables
ringo_hours = model.addVar(name="Ringo_hours", vtype=gurobi.GRB.INTEGER, lb=0)
laura_hours = model.addVar(name="Laura_hours", vtype=gurobi.GRB.CONTINUOUS, lb=0)

# Objective function
model.setObjective(9.58 * ringo_hours ** 2 + 1.36 * ringo_hours * laura_hours, gurobi.GRB.MAXIMIZE)

# Constraints
# 5. Computer competence rating squared minimum
model.addConstraint(2 ** 2 * ringo_hours ** 2 + 12 ** 2 * laura_hours ** 2 >= 21, "Computer competence rating squared minimum")

# 6. Organization score minimum
model.addConstraint(6 * ringo_hours + 12 * laura_hours >= 61, "Organization score minimum")

# 7. Linear constraint
model.addConstraint(8 * ringo_hours - 4 * laura_hours >= 0, "Linear constraint")

# 8. Computer competence rating squared maximum
model.addConstraint(2 ** 2 * ringo_hours ** 2 + 12 ** 2 * laura_hours ** 2 <= 46, "Computer competence rating squared maximum")

# 9. Computer competence rating linear maximum
model.addConstraint(2 * ringo_hours + 12 * laura_hours <= 46, "Computer competence rating linear maximum")

# 10. Organization score squared maximum
model.addConstraint(6 ** 2 * ringo_hours ** 2 + 12 ** 2 * laura_hours ** 2 <= 139 ** 2, "Organization score squared maximum")

# 11. Organization score linear maximum
model.addConstraint(6 * ringo_hours + 12 * laura_hours <= 139, "Organization score linear maximum")

# Solve the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Ringo hours:", ringo_hours.varValue)
    print("Laura hours:", laura_hours.varValue)
    print("Objective:", model.objVal)
else:
    print("The model is infeasible")
