
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("vitamin_optimization")

    # Create variables
    vitamin_d = m.addVar(lb=0, name="vitamin_d")
    vitamin_b7 = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="vitamin_b7")
    magnesium = m.addVar(lb=0, name="magnesium")
    zinc = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="zinc")
    vitamin_b2 = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="vitamin_b2")

    # Set objective function
    m.setObjective(5.67 * vitamin_d + 8.95 * vitamin_b7 + 7.6 * magnesium + 4.9 * zinc + 4.43 * vitamin_b2, gp.GRB.MAXIMIZE)

    # Add constraints based on digestive support index
    m.addConstr(vitamin_b7 + zinc >= 9)
    m.addConstr(vitamin_b7 + magnesium + zinc >= 6)
    m.addConstr(vitamin_b7 + zinc + vitamin_b2 >= 6)
    m.addConstr(vitamin_d + zinc + vitamin_b2 >= 6)
    m.addConstr(vitamin_b7 + magnesium + vitamin_b2 >= 6)
    m.addConstr(vitamin_b7 + magnesium + zinc >= 8)
    m.addConstr(vitamin_b7 + zinc + vitamin_b2 >= 8)
    m.addConstr(vitamin_d + zinc + vitamin_b2 >= 8)
    m.addConstr(vitamin_b7 + magnesium + vitamin_b2 >= 8)
    m.addConstr(vitamin_b7 + magnesium + zinc >= 6)  # Redundant
    m.addConstr(vitamin_b7 + zinc + vitamin_b2 >= 6)  # Redundant
    m.addConstr(vitamin_d + zinc + vitamin_b2 >= 6)  # Redundant
    m.addConstr(vitamin_b7 + magnesium + vitamin_b2 >= 6)  # Redundant
    m.addConstr(vitamin_b7 + magnesium + zinc >= 12)
    m.addConstr(vitamin_b7 + zinc + vitamin_b2 >= 12)
    m.addConstr(vitamin_d + zinc + vitamin_b2 >= 12)
    m.addConstr(vitamin_b7 + magnesium + vitamin_b2 >= 12)
    m.addConstr(zinc + vitamin_b2 <= 58)
    m.addConstr(magnesium + zinc <= 54)
    m.addConstr(vitamin_d + zinc <= 31)
    m.addConstr(vitamin_d + magnesium <= 41)
    m.addConstr(vitamin_b7 + magnesium <= 48)
    m.addConstr(vitamin_b7 + magnesium + vitamin_b2 <= 35)
    m.addConstr(vitamin_d + vitamin_b7 + magnesium <= 44)
    m.addConstr(vitamin_d + vitamin_b7 + vitamin_b2 <= 50)
    m.addConstr(magnesium + zinc + vitamin_b2 <= 45)
    m.addConstr(vitamin_b7 + zinc + vitamin_b2 <= 33)
    m.addConstr(vitamin_d + vitamin_b7 + magnesium + zinc + vitamin_b2 <= 33)


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
