
from gurobipy import Model, GRB

# Create a new model
m = Model("optimization_problem")

# Create variables
cucumber_vines = m.addVar(vtype=GRB.INTEGER, name="cucumber_vines")
carrots = m.addVar(vtype=GRB.INTEGER, name="carrots")
vincas = m.addVar(vtype=GRB.INTEGER, name="vincas")
roses = m.addVar(vtype=GRB.INTEGER, name="roses")

# Set objective function
m.setObjective(6 * cucumber_vines + 8 * carrots + 2 * vincas + 1 * roses, GRB.MAXIMIZE)

# Add constraints
m.addConstr(cucumber_vines + vincas + roses >= 24)
m.addConstr(cucumber_vines + carrots + vincas >= 24)
m.addConstr(cucumber_vines + vincas + roses >= 18)
m.addConstr(cucumber_vines + carrots + vincas >= 18)
m.addConstr(vincas + 3 * roses >= 34)
m.addConstr(8 * cucumber_vines + vincas >= 35)
m.addConstr(13 * carrots + 3 * roses >= 30)
m.addConstr(8 * cucumber_vines + 3 * roses >= 22)
m.addConstr(8 * cucumber_vines + 13 * carrots + vincas >= 34)
m.addConstr(cucumber_vines + 14 * vincas <= 81)
m.addConstr(16 * carrots + 14 * vincas <= 107)
m.addConstr(16 * carrots + 13 * roses <= 99)
m.addConstr(cucumber_vines + 13 * roses <= 141)
m.addConstr(14 * vincas + 13 * roses <= 68)
m.addConstr(cucumber_vines + 16 * carrots <= 60)
m.addConstr(cucumber_vines + 16 * carrots + 13 * roses <= 91)
m.addConstr(cucumber_vines + 16 * carrots + 14 * vincas + 13 * roses <= 91)
m.addConstr(vincas + 3 * roses <= 53)
m.addConstr(8 * cucumber_vines + 3 * roses <= 93)
m.addConstr(8 * cucumber_vines + vincas <= 102)
m.addConstr(8 * cucumber_vines + 13 * carrots + vincas + 3 * roses <= 102)


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

