
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    cucumber_vines = model.addVar(name="cucumber_vines", vtype=gurobi.GRB.INTEGER)
    carrots = model.addVar(name="carrots", vtype=gurobi.GRB.INTEGER)
    vincas = model.addVar(name="vincas", vtype=gurobi.GRB.INTEGER)
    roses = model.addVar(name="roses", vtype=gurobi.GRB.INTEGER)

    # Objective function
    model.setObjective(6 * cucumber_vines + 8 * carrots + 2 * vincas + roses, gurobi.GRB.MAXIMIZE)

    # Constraints
    # Yield constraints
    model.addConstr(cucumber_vines <= 1, name="cucumber_vines_yield")
    model.addConstr(16 * carrots <= 146, name="carrots_yield")
    model.addConstr(14 * vincas <= 146, name="vincas_yield")
    model.addConstr(13 * roses <= 146, name="roses_yield")

    # Beauty rating constraints
    model.addConstr(8 * cucumber_vines <= 149, name="cucumber_vines_beauty")
    model.addConstr(13 * carrots <= 149, name="carrots_beauty")
    model.addConstr(vincas <= 149, name="vincas_beauty")
    model.addConstr(3 * roses <= 149, name="roses_beauty")

    # Total yield constraints
    model.addConstr(cucumber_vines + vincas + roses >= 24, name="total_yield_1")
    model.addConstr(cucumber_vines + carrots + vincas >= 24, name="total_yield_2")
    model.addConstr(cucumber_vines + vincas + roses >= 18, name="total_yield_3")
    model.addConstr(cucumber_vines + carrots + vincas >= 18, name="total_yield_4")

    # Total beauty rating constraints
    model.addConstr(vincas + roses >= 34, name="total_beauty_1")
    model.addConstr(8 * cucumber_vines + vincas >= 35, name="total_beauty_2")
    model.addConstr(13 * carrots + 3 * roses >= 30, name="total_beauty_3")
    model.addConstr(8 * cucumber_vines + 3 * roses >= 22, name="total_beauty_4")
    model.addConstr(8 * cucumber_vines + 13 * carrots + vincas >= 34, name="total_beauty_5")

    # Upper bound constraints
    model.addConstr(cucumber_vines + vincas <= 81, name="upper_bound_1")
    model.addConstr(carrots + vincas <= 107, name="upper_bound_2")
    model.addConstr(carrots + roses <= 99, name="upper_bound_3")
    model.addConstr(cucumber_vines + roses <= 141, name="upper_bound_4")
    model.addConstr(vincas + roses <= 68, name="upper_bound_5")
    model.addConstr(cucumber_vines + carrots <= 60, name="upper_bound_6")
    model.addConstr(cucumber_vines + carrots + roses <= 91, name="upper_bound_7")
    model.addConstr(cucumber_vines + carrots + vincas + roses <= 91, name="upper_bound_8")

    # Beauty rating upper bounds
    model.addConstr(vincas + roses <= 53, name="beauty_upper_bound_1")
    model.addConstr(8 * cucumber_vines + 3 * roses <= 93, name="beauty_upper_bound_2")
    model.addConstr(8 * cucumber_vines + vincas <= 102, name="beauty_upper_bound_3")
    model.addConstr(8 * cucumber_vines + 13 * carrots + vincas + 3 * roses <= 102, name="beauty_upper_bound_4")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("Cucumber Vines: ", cucumber_vines.varValue)
        print("Carrots: ", carrots.varValue)
        print("Vincas: ", vincas.varValue)
        print("Roses: ", roses.varValue)
    else:
        print("Model is infeasible")

solve_optimization_problem()
