
from gurobipy import Model, GRB

# Create a new model
model = Model("Minimize Work Hours")

# Create variables
laura_hours = model.addVar(lb=0, name="laura_hours")
bobby_hours = model.addVar(lb=0, name="bobby_hours")
jean_hours = model.addVar(lb=0, name="jean_hours")

# Set objective function
model.setObjective(8 * laura_hours**2 + 6 * jean_hours**2 + laura_hours, GRB.MINIMIZE)

# Add constraints
model.addConstr(6 * bobby_hours**2 + 7 * jean_hours**2 >= 25, "paperwork_constraint1")
model.addConstr(12 * laura_hours + 6 * bobby_hours >= 21, "paperwork_constraint2")
model.addConstr(12 * laura_hours**2 + 6 * bobby_hours**2 + 7 * jean_hours**2 >= 54, "paperwork_constraint3")
model.addConstr(12 * laura_hours + 6 * bobby_hours + 7 * jean_hours >= 54, "paperwork_constraint4")
model.addConstr(6 * laura_hours + 16 * bobby_hours >= 40, "computer_constraint1")
model.addConstr(16 * bobby_hours + 8 * jean_hours >= 98, "computer_constraint2")
model.addConstr(6 * laura_hours + 16 * bobby_hours + 8 * jean_hours >= 98, "computer_constraint3")
model.addConstr(4 * laura_hours**2 - 4 * jean_hours**2 >= 0, "custom_constraint")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    print('Laura Hours: %g' % laura_hours.x)
    print('Bobby Hours: %g' % bobby_hours.x)
    print('Jean Hours: %g' % jean_hours.x)
elif model.status == GRB.INFEASIBLE:
    print('Model is infeasible')
else:
    print('Optimization ended with status %d' % model.status)

