
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define the decision variables
L = m.addVar(name="hours_worked_by_Laura", lb=0)
B = m.addVar(name="hours_worked_by_Bobby", lb=0)
J = m.addVar(name="hours_worked_by_Jean", lb=0)

# Set the objective function
m.setObjective(8*L**2 + 6*J**2 + L, GRB.MINIMIZE)

# Add constraints
m.addConstr(6*B**2 + 7*J**2 >= 25, name="paperwork_combined_1")
m.addConstr(12*L + 6*B >= 21, name="paperwork_laura_bobby")
m.addConstr(12*L**2 + 6*B**2 + 7*J**2 >= 54, name="paperwork_squared_sum")
m.addConstr(12*L + 6*B + 7*J >= 54, name="paperwork_linear_sum")
m.addConstr(6*L + 16*B >= 40, name="computer_laura_bobby")
m.addConstr(16*B + 8*J >= 98, name="computer_bobby_jean")
m.addConstr(6*L + 16*B + 8*J >= 98, name="computer_total")
m.addConstr(4*L**2 - 4*J**2 >= 0, name="laura_jean_ratio")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Hours worked by Laura: {L.x}")
    print(f"Hours worked by Bobby: {B.x}")
    print(f"Hours worked by Jean: {J.x}")
else:
    print("No optimal solution found.")
