
import gurobi

# Define the model
model = gurobi.Model()

# Define the variables
laura_hours = model.addVar(name="laura_hours", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)
bobby_hours = model.addVar(name="bobby_hours", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)
jean_hours = model.addVar(name="jean_hours", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)

# Objective function
model.setObjective(8 * laura_hours ** 2 + 6 * jean_hours ** 2 + laura_hours, gurobi.GRB.MINIMIZE)

# Constraints
# Paperwork and computer competence ratings
paperwork_laura = 12 * laura_hours
computer_laura = 6 * laura_hours
paperwork_bobby = 6 * bobby_hours
computer_bobby = 16 * bobby_hours
paperwork_jean = 7 * jean_hours
computer_jean = 8 * jean_hours

# The total combined paperwork competence rating from hours worked by Bobby squared, and hours worked by Jean squared must be equal to or greater than 25.
model.addConstraint(paperwork_bobby ** 2 + paperwork_jean ** 2 >= 25)

# The total combined paperwork competence rating from hours worked by Laura plus hours worked by Bobby must be no less than 21.
model.addConstraint(paperwork_laura + paperwork_bobby >= 21)

# The total combined paperwork competence rating from hours worked by Laura squared plus hours worked by Bobby squared plus hours worked by Jean squared must be 54 or more.
model.addConstraint(paperwork_laura ** 2 + paperwork_bobby ** 2 + paperwork_jean ** 2 >= 54)

# The total combined paperwork competence rating from hours worked by Laura, hours worked by Bobby, and hours worked by Jean should be 54 or more.
model.addConstraint(paperwork_laura + paperwork_bobby + paperwork_jean >= 54)

# The total combined computer competence rating from hours worked by Laura, and hours worked by Bobby has to be equal to or greater than 40.
model.addConstraint(computer_laura + computer_bobby >= 40)

# The total combined computer competence rating from hours worked by Bobby, and hours worked by Jean must be no less than 98.
model.addConstraint(computer_bobby + computer_jean >= 98)

# The total combined computer competence rating from hours worked by Laura plus hours worked by Bobby plus hours worked by Jean has to be no less than 98.
model.addConstraint(computer_laura + computer_bobby + computer_jean >= 98)

# Four times the number of hours worked by Laura squared, plus -4 times the number of hours worked by Jean squared has to be greater than or equal to zero.
model.addConstraint(4 * laura_hours ** 2 - 4 * jean_hours ** 2 >= 0)

# Solve the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Laura Hours: {laura_hours.varValue}")
    print(f"Bobby Hours: {bobby_hours.varValue}")
    print(f"Jean Hours: {jean_hours.varValue}")
    print(f"Objective: {model.objVal}")
else:
    print("The model is infeasible or unbounded.")
