
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
L = m.addVar(lb=0, name="hours_worked_by_Laura", vtype=gp.GRB.CONTINUOUS)
D = m.addVar(lb=0, name="hours_worked_by_Dale", vtype=gp.GRB.CONTINUOUS)
J = m.addVar(lb=0, name="hours_worked_by_John", vtype=gp.GRB.CONTINUOUS)

# Define the objective function
m.setObjective(3.01*L + 8.33*D + 4.51*J, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(13*L + 7*D >= 4, name="productivity_rating_Laura_Dale")
m.addConstr(13*L + 7*D + 8*J >= 4, name="productivity_rating_all")
m.addConstr(14*L + 3*D >= 15, name="work_quality_rating_Laura_Dale")
m.addConstr(3*D + 14*J >= 11, name="work_quality_rating_Dale_John")
m.addConstr(14*L + 3*D + 14*J >= 19, name="work_quality_rating_all")
m.addConstr(5*L + 14*D >= 17, name="organization_score_Laura_Dale")
m.addConstr(5*L + 14*D + 5*J >= 9, name="organization_score_all")
m.addConstr(-9*L + J >= 0, name="Laura_John_constraint")
m.addConstr(8*D - J >= 0, name="Dale_John_constraint")
m.addConstr(8*L - 4*D >= 0, name="Laura_Dale_constraint")
m.addConstr(13*L + 8*J <= 30, name="productivity_rating_Laura_John")
m.addConstr(13*L + 7*D <= 41, name="productivity_rating_Laura_Dale_max")
m.addConstr(13*L + 7*D + 8*J <= 42, name="productivity_rating_all_max")
m.addConstr(14*D + 5*J <= 33, name="organization_score_Dale_John_max")
m.addConstr(5*L + 5*J <= 39, name="organization_score_Laura_John_max")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Hours worked by Laura: ", L.varValue)
    print("Hours worked by Dale: ", D.varValue)
    print("Hours worked by John: ", J.varValue)
else:
    print("The model is infeasible")
