
from gurobipy import Model, GRB

# Create a new model
model = Model("Maximize Food Value")

# Create variables
corn_cobs = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="corn_cobs")
strawberries = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="strawberries")
milkshakes = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="milkshakes")

# Set objective function
model.setObjective(9 * corn_cobs + 7 * strawberries + 1 * milkshakes, GRB.MAXIMIZE)

# Add constraints
model.addConstr(0.03 * corn_cobs + 0.14 * milkshakes >= 47, "c1")
model.addConstr(0.93 * strawberries + 0.14 * milkshakes >= 61, "c2")
model.addConstr(0.03 * corn_cobs + 0.93 * strawberries >= 92, "c3")
model.addConstr(0.03 * corn_cobs + 0.93 * strawberries + 0.14 * milkshakes >= 79, "c4")
model.addConstr(0.93 * strawberries + 0.14 * milkshakes <= 185, "c5")
model.addConstr(0.03 * corn_cobs + 0.14 * milkshakes <= 145, "c6")
model.addConstr(0.03 * corn_cobs + 0.93 * strawberries <= 163, "c7")
model.addConstr(0.03 * corn_cobs + 0.93 * strawberries + 0.14 * milkshakes <= 163, "c8")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    print('corn_cobs:', corn_cobs.x)
    print('strawberries:', strawberries.x)
    print('milkshakes:', milkshakes.x)
elif model.status == GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % model.status)

