
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Create decision variables
corn_cobs = m.addVar(lb=0, name="corn_cobs", vtype=GRB.CONTINUOUS)
strawberries = m.addVar(lb=0, name="strawberries", vtype=GRB.CONTINUOUS)
milkshakes = m.addVar(lb=0, name="milkshakes", vtype=GRB.CONTINUOUS)

# Define the objective function
m.setObjective(9 * corn_cobs + 7 * strawberries + 1 * milkshakes, GRB.MAXIMIZE)

# Add constraints
m.addConstr(0.03 * corn_cobs + 0.14 * milkshakes >= 47)
m.addConstr(0.93 * strawberries + 0.14 * milkshakes >= 61)
m.addConstr(0.03 * corn_cobs + 0.93 * strawberries >= 92)
m.addConstr(0.03 * corn_cobs + 0.93 * strawberries + 0.14 * milkshakes >= 79)
m.addConstr(0.93 * strawberries + 0.14 * milkshakes <= 185)
m.addConstr(0.03 * corn_cobs + 0.14 * milkshakes <= 145)
m.addConstr(0.03 * corn_cobs + 0.93 * strawberries <= 163)
m.addConstr(0.03 * corn_cobs + 0.93 * strawberries + 0.14 * milkshakes <= 163)

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Corn Cobs: {corn_cobs.x}")
    print(f"Strawberries: {strawberries.x}")
    print(f"Milkshakes: {milkshakes.x}")
else:
    print("No optimal solution found")
