
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define variables
    corn_cobs = model.addVar(lb=0, name="corn_cobs", vtype=gurobi.GRB.CONTINUOUS)
    strawberries = model.addVar(lb=0, name="strawberries", vtype=gurobi.GRB.CONTINUOUS)
    milkshakes = model.addVar(lb=0, name="milkshakes", vtype=gurobi.GRB.CONTINUOUS)

    # Objective function: Maximize 9*corn_cobs + 7*strawberries + 1*milkshakes
    model.setObjective(9*corn_cobs + 7*strawberries + 1*milkshakes, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(0.03*corn_cobs + 0.14*milkshakes >= 47, name="health_rating_cc_mc")
    model.addConstr(0.93*strawberries + 0.14*milkshakes >= 61, name="health_rating_s_mc")
    model.addConstr(0.03*corn_cobs + 0.93*strawberries >= 92, name="health_rating_cc_s")
    model.addConstr(0.03*corn_cobs + 0.93*strawberries + 0.14*milkshakes >= 79, name="health_rating_all")
    model.addConstr(0.93*strawberries + 0.14*milkshakes <= 185, name="health_rating_s_mc_upper")
    model.addConstr(0.03*corn_cobs + 0.14*milkshakes <= 145, name="health_rating_cc_mc_upper")
    model.addConstr(0.03*corn_cobs + 0.93*strawberries <= 163, name="health_rating_cc_s_upper")
    model.addConstr(0.03*corn_cobs + 0.93*strawberries + 0.14*milkshakes <= 163, name="health_rating_all_upper")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Corn Cobs: {corn_cobs.varValue}")
        print(f"Strawberries: {strawberries.varValue}")
        print(f"Milkshakes: {milkshakes.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("The model is infeasible.")

solve_optimization_problem()
