
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
green_beans = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="green_beans")
cherry_pies = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="cherry_pies")
fruit_salads = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="fruit_salads")
kiwis = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="kiwis")

# Set objective function
m.setObjective(6 * green_beans + 6 * cherry_pies + 4 * fruit_salads + 1 * kiwis, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(14 * cherry_pies + 12 * kiwis >= 34, "c1")
m.addConstr(1 * green_beans + 14 * cherry_pies >= 40, "c2")
m.addConstr(1 * green_beans + 5 * fruit_salads >= 78, "c3")
m.addConstr(1 * green_beans + 12 * kiwis >= 62, "c4")
m.addConstr(1 * green_beans + 14 * cherry_pies + 5 * fruit_salads + 12 * kiwis >= 62, "c5")
m.addConstr(14 * fruit_salads + 7 * kiwis >= 34, "c6")
m.addConstr(12 * cherry_pies + 7 * kiwis >= 35, "c7")
m.addConstr(12 * cherry_pies + 14 * fruit_salads + 7 * kiwis >= 34, "c8")
m.addConstr(5 * green_beans + 12 * cherry_pies + 14 * fruit_salads >= 34, "c9")
m.addConstr(5 * green_beans + 12 * cherry_pies + 7 * kiwis >= 34, "c10")
m.addConstr(5 * green_beans + 14 * fruit_salads + 7 * kiwis >= 34, "c11")
m.addConstr(12 * cherry_pies + 14 * fruit_salads + 7 * kiwis >= 39, "c12")
m.addConstr(5 * green_beans + 12 * cherry_pies + 14 * fruit_salads >= 39, "c13")
m.addConstr(5 * green_beans + 12 * cherry_pies + 7 * kiwis >= 39, "c14")
m.addConstr(5 * green_beans + 14 * fruit_salads + 7 * kiwis >= 39, "c15")
m.addConstr(12 * cherry_pies + 14 * fruit_salads + 7 * kiwis >= 23, "c16")
m.addConstr(5 * green_beans + 12 * cherry_pies + 14 * fruit_salads >= 23, "c17")
m.addConstr(5 * green_beans + 12 * cherry_pies + 7 * kiwis >= 23, "c18")
m.addConstr(5 * green_beans + 14 * fruit_salads + 7 * kiwis >= 23, "c19")
m.addConstr(12 * cherry_pies + 14 * fruit_salads + 7 * kiwis >= 36, "c20")
m.addConstr(5 * green_beans + 12 * cherry_pies + 14 * fruit_salads >= 36, "c21")
m.addConstr(5 * green_beans + 12 * cherry_pies + 7 * kiwis >= 36, "c22")
m.addConstr(5 * green_beans + 14 * fruit_salads + 7 * kiwis >= 36, "c23")
m.addConstr(5 * green_beans + 12 * cherry_pies + 14 * fruit_salads + 7 * kiwis >= 36, "c24")
m.addConstr(-10 * green_beans + 6 * fruit_salads >= 0, "c25")
m.addConstr(-4 * green_beans + 8 * cherry_pies >= 0, "c26")
m.addConstr(5 * fruit_salads + 12 * kiwis <= 142, "c27")
m.addConstr(1 * green_beans + 5 * fruit_salads <= 294, "c28")
m.addConstr(14 * cherry_pies + 12 * kiwis <= 277, "c29")
m.addConstr(1 * green_beans + 14 * cherry_pies <= 230, "c30")
m.addConstr(1 * green_beans + 14 * cherry_pies + 12 * kiwis <= 184, "c31")
m.addConstr(1 * green_beans + 5 * fruit_salads + 12 * kiwis <= 270, "c32")
m.addConstr(12 * cherry_pies + 14 * fruit_salads <= 58, "c33")
m.addConstr(5 * green_beans + 14 * fruit_salads + 7 * kiwis <= 45, "c34")
m.addConstr(5 * green_beans + 12 * cherry_pies + 14 * fruit_salads <= 79, "c35")
m.addConstr(5 * green_beans + 12 * cherry_pies + 7 * kiwis <= 63, "c36")


# Resource constraints (given in the problem description)
m.addConstr(1 * green_beans + 14 * cherry_pies + 5 * fruit_salads + 12 * kiwis <= 339, "umami_limit")
m.addConstr(5 * green_beans + 12 * cherry_pies + 14 * fruit_salads + 7 * kiwis <= 162, "cost_limit")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

