
import gurobi

def optimize_problem():
    model = gurobi.Model()
    
    # Define variables
    green_beans = model.addVar(name="green_beans", lb=0)
    cherry_pies = model.addVar(name="cherry_pies", lb=0)
    fruit_salads = model.addVar(name="fruit_salads", lb=0)
    kiwis = model.addVar(name="kiwis", lb=0)
    
    # Objective function
    model.setObjective(6 * green_beans + 6 * cherry_pies + 4 * fruit_salads + kiwis, gurobi.GRB.MINIMIZE)
    
    # Constraints
    model.addConstr(14 * cherry_pies + 12 * kiwis >= 34)
    model.addConstr(green_beans + 14 * cherry_pies >= 40)
    model.addConstr(green_beans + 5 * fruit_salads >= 78)
    model.addConstr(green_beans + 12 * kiwis >= 62)
    model.addConstr(green_beans + 14 * cherry_pies + 5 * fruit_salads + 12 * kiwis >= 62)
    model.addConstr(5 * fruit_salads + 7 * kiwis >= 34)
    model.addConstr(12 * cherry_pies + 7 * kiwis >= 35)
    model.addConstr(12 * cherry_pies + 14 * fruit_salads + 7 * kiwis >= 34)
    model.addConstr(5 * green_beans + 12 * cherry_pies + 14 * fruit_salads >= 34)
    model.addConstr(5 * green_beans + 12 * cherry_pies + 7 * kiwis >= 34)
    model.addConstr(5 * green_beans + 14 * fruit_salads + 7 * kiwis >= 34)
    model.addConstr(12 * cherry_pies + 14 * fruit_salads + 7 * kiwis >= 39)
    model.addConstr(5 * green_beans + 12 * cherry_pies + 14 * fruit_salads >= 39)
    model.addConstr(5 * green_beans + 12 * cherry_pies + 7 * kiwis >= 39)
    model.addConstr(5 * green_beans + 14 * fruit_salads + 7 * kiwis >= 39)
    model.addConstr(12 * cherry_pies + 14 * fruit_salads + 7 * kiwis >= 23)
    model.addConstr(5 * green_beans + 12 * cherry_pies + 14 * fruit_salads >= 23)
    model.addConstr(5 * green_beans + 12 * cherry_pies + 7 * kiwis >= 23)
    model.addConstr(5 * green_beans + 14 * fruit_salads + 7 * kiwis >= 23)
    model.addConstr(12 * cherry_pies + 14 * fruit_salads + 7 * kiwis >= 36)
    model.addConstr(5 * green_beans + 12 * cherry_pies + 14 * fruit_salads >= 36)
    model.addConstr(5 * green_beans + 12 * cherry_pies + 7 * kiwis >= 36)
    model.addConstr(5 * green_beans + 14 * fruit_salads + 7 * kiwis >= 36)
    model.addConstr(5 * green_beans + 12 * cherry_pies + 14 * fruit_salads + 7 * kiwis >= 36)
    
    model.addConstr(-10 * green_beans + 6 * fruit_salads >= 0)
    model.addConstr(-4 * green_beans + 8 * cherry_pies >= 0)
    model.addConstr(5 * fruit_salads + 12 * kiwis <= 142)
    model.addConstr(green_beans + 5 * fruit_salads <= 294)
    model.addConstr(14 * cherry_pies + 12 * kiwis <= 277)
    model.addConstr(green_beans + 14 * cherry_pies <= 230)
    model.addConstr(green_beans + 14 * cherry_pies + 12 * kiwis <= 184)
    model.addConstr(green_beans + 5 * fruit_salads + 12 * kiwis <= 270)
    model.addConstr(12 * cherry_pies + 14 * fruit_salads <= 58)
    model.addConstr(5 * green_beans + 14 * fruit_salads + 7 * kiwis <= 45)
    model.addConstr(5 * green_beans + 12 * cherry_pies + 14 * fruit_salads <= 79)
    model.addConstr(5 * green_beans + 12 * cherry_pies + 7 * kiwis <= 63)
    
    model.optimize()
    
    if model.status == gurobi.GRB.Status.OPTIMAL:
        print("Objective: ", model.objVal)
        print("Green Beans: ", green_beans.varValue)
        print("Cherry Pies: ", cherry_pies.varValue)
        print("Fruit Salads: ", fruit_salads.varValue)
        print("Kiwis: ", kiwis.varValue)
    else:
        print("No solution found")

optimize_problem()
