
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x = m.addVars(['dish soap bottles', 'bottles of ibuprofen', 'diapers', 'lightbulbs'], name="x", vtype=gp.GRB.INTEGER)

# Set objective function
m.setObjective(3 * x['dish soap bottles'] + 1 * x['bottles of ibuprofen'] + 9 * x['diapers'] + 2 * x['lightbulbs'], gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(20.33 * x['diapers'] + 1.14 * x['lightbulbs'] >= 76, "c1")
m.addConstr(5.02 * x['dish soap bottles'] + 20.33 * x['diapers'] >= 52, "c2")
m.addConstr(13.37 * x['bottles of ibuprofen'] + 20.33 * x['diapers'] <= 146, "c3")
m.addConstr(13.37 * x['bottles of ibuprofen'] + 1.14 * x['lightbulbs'] <= 292, "c4")
m.addConstr(5.02 * x['dish soap bottles'] + 13.37 * x['bottles of ibuprofen'] <= 208, "c5")
m.addConstr(5.02 * x['dish soap bottles'] + 1.14 * x['lightbulbs'] <= 163, "c6")
m.addConstr(13.37 * x['bottles of ibuprofen'] + 20.33 * x['diapers'] + 1.14 * x['lightbulbs'] <= 206, "c7")
m.addConstr(5.02 * x['dish soap bottles'] + 13.37 * x['bottles of ibuprofen'] + 20.33 * x['diapers'] + 1.14 * x['lightbulbs'] <= 206, "c8")


# Add non-negativity constraints implicitly by setting vtype to INTEGER

# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

