
import gurobi

def optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    dish_soap_bottles = model.addVar(name="dish_soap_bottles", vtype=gurobi.GRB.INTEGER)
    bottles_ibuprofen = model.addVar(name="bottles_ibuprofen", vtype=gurobi.GRB.INTEGER)
    diapers = model.addVar(name="diapers", vtype=gurobi.GRB.INTEGER)
    lightbulbs = model.addVar(name="lightbulbs", vtype=gurobi.GRB.INTEGER)

    # Objective function
    model.setObjective(3 * dish_soap_bottles + bottles_ibuprofen + 9 * diapers + 2 * lightbulbs, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(20.33 * diapers + 1.14 * lightbulbs >= 76, name="diapers_lightbulbs_min_weight")
    model.addConstr(5.02 * dish_soap_bottles + 20.33 * diapers >= 52, name="dish_soap_diapers_min_weight")
    model.addConstr(13.37 * bottles_ibuprofen + 20.33 * diapers <= 146, name="ibuprofen_diapers_max_weight")
    model.addConstr(13.37 * bottles_ibuprofen + 1.14 * lightbulbs <= 292, name="ibuprofen_lightbulbs_max_weight")
    model.addConstr(5.02 * dish_soap_bottles + 13.37 * bottles_ibuprofen <= 208, name="dish_soap_ibuprofen_max_weight")
    model.addConstr(5.02 * dish_soap_bottles + 1.14 * lightbulbs <= 163, name="dish_soap_lightbulbs_max_weight")
    model.addConstr(13.37 * bottles_ibuprofen + 20.33 * diapers + 1.14 * lightbulbs <= 206, name="ibuprofen_diapers_lightbulbs_max_weight")
    model.addConstr(5.02 * dish_soap_bottles + 13.37 * bottles_ibuprofen + 20.33 * diapers + 1.14 * lightbulbs <= 395, name="total_max_weight")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Dish soap bottles: {dish_soap_bottles.varValue}")
        print(f"Bottles of ibuprofen: {bottles_ibuprofen.varValue}")
        print(f"Diapers: {diapers.varValue}")
        print(f"Lightbulbs: {lightbulbs.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("The model is infeasible.")

optimization_problem()
