
import gurobipy as gp

# Create a new model
m = gp.Model("resource_allocation")

# Create variables
mary_hours = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="mary_hours")
john_hours = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="john_hours")
hank_hours = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="hank_hours")

# Set objective function
m.setObjective(9.69 * mary_hours + 4.91 * john_hours + 9.83 * hank_hours, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(3 * mary_hours + 6 * hank_hours >= 36, "paperwork_mary_hank")
m.addConstr(3 * mary_hours + 7 * john_hours + 6 * hank_hours >= 36, "paperwork_total")
m.addConstr(4 * john_hours + 8 * hank_hours >= 18, "organization_john_hank")
m.addConstr(1 * mary_hours + 8 * hank_hours >= 16, "organization_mary_hank")
m.addConstr(1 * mary_hours + 4 * john_hours + 8 * hank_hours >= 36, "organization_total")
m.addConstr(-5 * mary_hours + 6 * hank_hours >= 0, "constraint_1")
m.addConstr(2 * john_hours - 8 * hank_hours >= 0, "constraint_2")
m.addConstr(3 * mary_hours + 7 * john_hours <= 110, "paperwork_mary_john_max")
m.addConstr(3 * mary_hours + 7 * john_hours + 6 * hank_hours <= 63, "paperwork_total_max")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Optimal objective: %g' % m.objVal)
    print('Mary hours: %g' % mary_hours.x)
    print('John hours: %g' % john_hours.x)
    print('Hank hours: %g' % hank_hours.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('Model is infeasible')
else:
    print('Optimization ended with status %d' % m.status)

