
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
hours_mary = m.addVar(lb=0, name="hours_worked_by_Mary")
hours_john = m.addVar(lb=0, name="hours_worked_by_John")
hours_hank = m.addVar(lb=0, name="hours_worked_by_Hank")

# Objective function
m.setObjective(9.69 * hours_mary + 4.91 * hours_john + 9.83 * hours_hank, GRB.MINIMIZE)

# Constraints
# Minimum total paperwork competence rating from Mary and Hank
m.addConstr(3 * hours_mary + 6 * hours_hank >= 36, name="paperwork_MH_min")

# Minimum total paperwork competence rating from all
m.addConstr(3 * hours_mary + 7 * hours_john + 6 * hours_hank >= 36, name="paperwork_all_min")

# Minimum total organization score from John and Hank
m.addConstr(4 * hours_john + 8 * hours_hank >= 18, name="organization_JH_min")

# Minimum total organization score from Mary and Hank
m.addConstr(hours_mary + 8 * hours_hank >= 16, name="organization_MH_min")

# Minimum total organization score from all
m.addConstr(hours_mary + 4 * hours_john + 8 * hours_hank >= 36, name="organization_all_min")

# Additional constraints
m.addConstr(-5 * hours_mary + 6 * hours_hank >= 0, name="additional_1")
m.addConstr(2 * hours_john - 8 * hours_hank >= 0, name="additional_2")

# Maximum total paperwork competence rating from Mary and John
m.addConstr(3 * hours_mary + 7 * hours_john <= 110, name="paperwork_MJ_max")

# Maximum total paperwork competence rating from all
m.addConstr(3 * hours_mary + 7 * hours_john + 6 * hours_hank <= 63, name="paperwork_all_max")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Hours worked by Mary: {hours_mary.x}")
    print(f"Hours worked by John: {hours_john.x}")
    print(f"Hours worked by Hank: {hours_hank.x}")
else:
    print("No optimal solution found.")

