
import gurobi

def optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    M = model.addVar(lb=0, name="hours_worked_by_Mary")  # Hours worked by Mary
    J = model.addVar(lb=0, name="hours_worked_by_John")  # Hours worked by John
    H = model.addVar(lb=0, name="hours_worked_by_Hank")  # Hours worked by Hank

    # Objective function: Minimize 9.69M + 4.91J + 9.83H
    model.setObjective(9.69 * M + 4.91 * J + 9.83 * H, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(3 * M + 6 * H >= 36)  # Constraint 7
    model.addConstr(3 * M + 7 * J + 6 * H >= 36)  # Constraint 8
    model.addConstr(4 * J + 8 * H >= 18)  # Constraint 9
    model.addConstr(M + 8 * H >= 16)  # Constraint 10
    model.addConstr(M + 4 * J + 8 * H >= 36)  # Constraint 11
    model.addConstr(-5 * M + 6 * H >= 0)  # Constraint 12
    model.addConstr(2 * J - 8 * H >= 0)  # Constraint 13
    model.addConstr(3 * M + 7 * J <= 110)  # Constraint 14
    model.addConstr(3 * M + 7 * J + 6 * H <= 63)  # Constraint 15

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Hours worked by Mary: {M.varValue}")
        print(f"Hours worked by John: {J.varValue}")
        print(f"Hours worked by Hank: {H.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

optimization_problem()
