
from gurobipy import Model, GRB

# Create a new model
model = Model("Maximize Granola Bar Value")

# Create variables
bananas = model.addVar(lb=0, name="bananas")  # Continuous variable
granola_bars = model.addVar(lb=0, vtype=GRB.INTEGER, name="granola_bars") # Integer variable

# Set objective function
model.setObjective(1 * bananas + 8 * granola_bars, GRB.MAXIMIZE)

# Add constraints
model.addConstr(14 * bananas + 8 * granola_bars >= 38, "min_cost")
model.addConstr(11 * bananas + 9 * granola_bars >= 145, "min_health")
model.addConstr(-4 * bananas + 9 * granola_bars >= 0, "banana_granola_ratio")
model.addConstr(14 * bananas + 8 * granola_bars <= 111, "max_cost") # Combined max cost constraint
model.addConstr(11 * bananas + 9 * granola_bars <= 255, "max_health") # Combined max health constraint


# Optimize model
model.optimize()

# Check for infeasibility
if model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    # Print results
    print("Optimal Solution:")
    print(f"Bananas: {bananas.x}")
    print(f"Granola Bars: {granola_bars.x}")
    print(f"Objective Value: {model.objVal}")

