
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define variables
bananas = m.addVar(vtype=GRB.CONTINUOUS, name="bananas")
granola_bars = m.addVar(vtype=GRB.INTEGER, name="granola_bars")

# Objective function: Maximize 1 * bananas + 8 * granola_bars
m.setObjective(1 * bananas + 8 * granola_bars, GRB.MAXIMIZE)

# Constraints
# 1. Dollar cost constraint
m.addConstr(14 * bananas + 8 * granola_bars >= 38, name="min_cost")
m.addConstr(14 * bananas + 8 * granola_bars <= 111, name="max_cost")

# 2. Healthiness rating constraint
m.addConstr(11 * bananas + 9 * granola_bars >= 145, name="min_health")
m.addConstr(11 * bananas + 9 * granola_bars <= 255, name="max_health")

# 3. Additional linear constraint
m.addConstr(-4 * bananas + 9 * granola_bars >= 0, name="additional_constraint")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print("Bananas:", bananas.x)
    print("Granola Bars:", granola_bars.x)
    print("Objective Value:", m.objVal)
else:
    print("No optimal solution found")
