
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    bananas = model.addVar(name="bananas", lb=0)  # No lower bound specified, assuming 0
    granola_bars = model.addVar(name="granola_bars", lb=0, integrality=gurobi.GRB.INTEGER)

    # Objective function: Maximize 1 * bananas + 8 * granola_bars
    model.setObjective(bananas + 8 * granola_bars, gurobi.GRB.MAXIMIZE)

    # Constraints
    # Cost of bananas and granola bars: 14 * bananas + 8 * granola_bars >= 38
    model.addConstr(14 * bananas + 8 * granola_bars >= 38, name="min_spending")

    # Healthiness rating: 11 * bananas + 9 * granola_bars >= 145
    model.addConstr(11 * bananas + 9 * granola_bars >= 145, name="min_healthiness")

    # Constraint: -4 * bananas + 9 * granola_bars >= 0
    model.addConstr(-4 * bananas + 9 * granola_bars >= 0, name="special_constraint")

    # Maximum spending: 14 * bananas + 8 * granola_bars <= 166
    model.addConstr(14 * bananas + 8 * granola_bars <= 166, name="max_spending")

    # Maximum healthiness rating: 11 * bananas + 9 * granola_bars <= 335
    model.addConstr(11 * bananas + 9 * granola_bars <= 335, name="max_healthiness")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution found.")
        print(f"Bananas: {bananas.varValue}")
        print(f"Granola Bars: {granola_bars.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
