
from gurobipy import Model, GRB

# Create a new model
model = Model("nutrition_optimization")

# Create variables
calcium = model.addVar(vtype=GRB.INTEGER, name="calcium")
vitamin_b7 = model.addVar(name="vitamin_b7")

# Set objective function
model.setObjective(5.78 * calcium + 5.62 * vitamin_b7, GRB.MINIMIZE)

# Add constraints
model.addConstr(13 * calcium + 11 * vitamin_b7 >= 44, "kidney_support_min")
model.addConstr(13 * calcium + 11 * vitamin_b7 <= 98, "kidney_support_max")

model.addConstr(1 * calcium + 1 * vitamin_b7 >= 15, "cognitive_performance_min")
model.addConstr(1 * calcium + 1 * vitamin_b7 <= 53, "cognitive_performance_max")

model.addConstr(13 * calcium + 11 * vitamin_b7 >= 13, "muscle_growth_min")
model.addConstr(13 * calcium + 11 * vitamin_b7 <= 34, "muscle_growth_max")

model.addConstr(4 * calcium - 9 * vitamin_b7 >= 0, "additional_constraint")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal solution found:")
    print(f"  Calcium: {calcium.x}")
    print(f"  Vitamin B7: {vitamin_b7.x}")
    print(f"  Objective value: {model.objVal}")
elif model.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

