
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Decision Variables
x0 = m.addVar(vtype=GRB.INTEGER, name="milligrams_of_calcium")
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="milligrams_of_vitamin_B7", lb=0)

# Objective Function: Minimize 5.78*x0 + 5.62*x1
m.setObjective(5.78*x0 + 5.62*x1, GRB.MINIMIZE)

# Constraints
# Total combined kidney support index from both sources is at least 44
m.addConstr(13*x0 + 11*x1 >= 44, name="kidney_support_index_min")

# Total combined cognitive performance index from both sources is at least 15
m.addConstr(x0 + x1 >= 15, name="cognitive_performance_index_min")

# Total combined muscle growth index from both sources is at least 13
m.addConstr(13*x0 + 11*x1 >= 13, name="muscle_growth_index_min")

# 4*x0 - 9*x1 >= 0
m.addConstr(4*x0 - 9*x1 >= 0, name="custom_constraint")

# Total combined kidney support index from both sources is at most 98
m.addConstr(13*x0 + 11*x1 <= 98, name="kidney_support_index_max")

# Total combined cognitive performance index from both sources is at most 53
m.addConstr(x0 + x1 <= 53, name="cognitive_performance_index_max")

# Total combined muscle growth index from both sources is at most 34
m.addConstr(13*x0 + 11*x1 <= 34, name="muscle_growth_index_max")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"milligrams_of_calcium: {x0.x}")
    print(f"milligrams_of_vitamin_B7: {x1.x}")
else:
    print("No optimal solution found")
