
import gurobi

def optimize_nutrition():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define variables
    calcium = model.addVar(name="calcium", vtype=gurobi.GRB.INTEGER)  # Milligrams of calcium
    vitamin_b7 = model.addVar(name="vitamin_b7")  # Milligrams of vitamin B7

    # Objective function: Minimize 5.78*calcium + 5.62*vitamin_b7
    model.setObjective(5.78 * calcium + 5.62 * vitamin_b7, gurobi.GRB.MINIMIZE)

    # Constraints
    # Individual indexes
    model.addConstr(13 * calcium <= 112, name="calcium_kidney_support")
    model.addConstr(1 * calcium <= 80, name="calcium_cognitive_performance")
    model.addConstr(13 * calcium <= 50, name="calcium_muscle_growth")

    model.addConstr(11 * vitamin_b7 <= 112, name="vitamin_b7_kidney_support")
    model.addConstr(1 * vitamin_b7 <= 80, name="vitamin_b7_cognitive_performance")
    model.addConstr(11 * vitamin_b7 <= 50, name="vitamin_b7_muscle_growth")

    # Combined indexes
    model.addConstr(13 * calcium + 11 * vitamin_b7 >= 44, name="combined_kidney_support_min")
    model.addConstr(13 * calcium + 11 * vitamin_b7 <= 98, name="combined_kidney_support_max")

    model.addConstr(1 * calcium + 1 * vitamin_b7 >= 15, name="combined_cognitive_performance_min")
    model.addConstr(1 * calcium + 1 * vitamin_b7 <= 53, name="combined_cognitive_performance_max")

    model.addConstr(13 * calcium + 11 * vitamin_b7 >= 13, name="combined_muscle_growth_min")
    model.addConstr(13 * calcium + 11 * vitamin_b7 <= 34, name="combined_muscle_growth_max")

    # Additional constraint
    model.addConstr(4 * calcium - 9 * vitamin_b7 >= 0, name="additional_constraint")

    # Solve the model
    model.optimize()

    # Print the results
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Milligrams of Calcium: {calcium.varValue}")
        print(f"Milligrams of Vitamin B7: {vitamin_b7.varValue}")
        print(f"Objective Function Value: {model.objVal}")
    else:
        print("The model is infeasible.")

optimize_nutrition()
