
from gurobipy import Model, GRB

# Create a new model
model = Model("food_optimization")

# Create variables
bacon = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="strips_of_bacon")
pies = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="cherry_pies")
pizza = model.addVar(lb=0, vtype=GRB.INTEGER, name="slices_of_pizza")
salads = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="bagged_salads")
sandwiches = model.addVar(lb=0, vtype=GRB.INTEGER, name="peanutbutter_sandwiches")

# Set objective function
model.setObjective(3.17 * bacon + 8.18 * pies + 6.91 * pizza + 8.42 * salads + 4.16 * sandwiches, GRB.MINIMIZE)

# Add constraints
model.addConstr(9 * bacon + 8 * pies >= 27, "c1")
model.addConstr(9 * bacon + 12 * sandwiches >= 53, "c2")
model.addConstr(6 * salads + 12 * sandwiches >= 35, "c3")
model.addConstr(10 * pizza + 12 * sandwiches >= 40, "c4")
model.addConstr(8 * pies + 12 * sandwiches >= 66, "c5")
model.addConstr(9 * bacon + 8 * pies + 10 * pizza + 6 * salads + 12 * sandwiches >= 66, "c6")
model.addConstr(9 * bacon + 8 * pies <= 143, "c7")
model.addConstr(8 * pies + 6 * salads <= 254, "c8")
model.addConstr(8 * pies + 6 * salads + 12 * sandwiches <= 110, "c9")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    print('Bacon:', bacon.x)
    print('Pies:', pies.x)
    print('Pizza:', pizza.x)
    print('Salads:', salads.x)
    print('Sandwiches:', sandwiches.x)
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

