
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define the variables
strips_of_bacon = m.addVar(lb=0, ub=GRB.INFINITY, vtype=GRB.CONTINUOUS, name="strips_of_bacon")
cherry_pies = m.addVar(lb=0, ub=GRB.INFINITY, vtype=GRB.CONTINUOUS, name="cherry_pies")
slices_of_pizza = m.addVar(lb=0, ub=GRB.INFINITY, vtype=GRB.INTEGER, name="slices_of_pizza")
bagged_salads = m.addVar(lb=0, ub=GRB.INFINITY, vtype=GRB.CONTINUOUS, name="bagged_salads")
peanutbutter_sandwiches = m.addVar(lb=0, ub=GRB.INFINITY, vtype=GRB.INTEGER, name="peanutbutter_sandwiches")

# Define the objective function
m.setObjective(3.17 * strips_of_bacon + 8.18 * cherry_pies + 6.91 * slices_of_pizza + 8.42 * bagged_salads + 4.16 * peanutbutter_sandwiches, GRB.MINIMIZE)

# Define the constraints
m.addConstr(9 * strips_of_bacon + 8 * cherry_pies >= 27, name="constraint_1")
m.addConstr(9 * strips_of_bacon + 12 * peanutbutter_sandwiches >= 53, name="constraint_2")
m.addConstr(6 * bagged_salads + 12 * peanutbutter_sandwiches >= 35, name="constraint_3")
m.addConstr(10 * slices_of_pizza + 12 * peanutbutter_sandwiches >= 40, name="constraint_4")
m.addConstr(8 * cherry_pies + 12 * peanutbutter_sandwiches >= 66, name="constraint_5")
m.addConstr(9 * strips_of_bacon + 8 * cherry_pies + 10 * slices_of_pizza + 6 * bagged_salads + 12 * peanutbutter_sandwiches >= 66, name="constraint_6")
m.addConstr(9 * strips_of_bacon + 8 * cherry_pies <= 143, name="constraint_7")
m.addConstr(8 * cherry_pies + 6 * bagged_salads <= 254, name="constraint_8")
m.addConstr(8 * cherry_pies + 6 * bagged_salads + 12 * peanutbutter_sandwiches <= 110, name="constraint_9")

# Optimize the model
m.optimize()

