
import gurobi

def optimize_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="strips of bacon")
    x1 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="cherry pies")
    x2 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, vtype=gurobi.GRB.INTEGER, name="slices of pizza")
    x3 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="bagged salads")
    x4 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, vtype=gurobi.GRB.INTEGER, name="peanutbutter sandwiches")

    # Objective function
    model.setObjective(3.17*x0 + 8.18*x1 + 6.91*x2 + 8.42*x3 + 4.16*x4, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(9*x0 + 8*x1 >= 27)
    model.addConstr(9*x0 + 12*x4 >= 53)
    model.addConstr(6*x3 + 12*x4 >= 35)
    model.addConstr(10*x2 + 12*x4 >= 40)
    model.addConstr(8*x1 + 12*x4 >= 66)
    model.addConstr(9*x0 + 8*x1 + 10*x2 + 6*x3 + 12*x4 >= 66)
    model.addConstr(9*x0 + 8*x1 <= 143)
    model.addConstr(8*x1 + 6*x3 <= 254)
    model.addConstr(8*x1 + 6*x3 + 12*x4 <= 110)

    # Bounds
    model.addConstr(x0 >= 0)
    model.addConstr(x1 >= 0)
    model.addConstr(x3 >= 0)
    model.addConstr(x4 >= 0)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objval)
        print("Strips of bacon: ", x0.varValue)
        print("Cherry pies: ", x1.varValue)
        print("Slices of pizza: ", x2.varValue)
        print("Bagged salads: ", x3.varValue)
        print("Peanutbutter sandwiches: ", x4.varValue)
    else:
        print("The model is infeasible")

optimize_problem()
