
from gurobipy import Model, GRB

# Create a new model
m = Model("plant_optimization")

# Create variables
sunflowers = m.addVar(vtype=GRB.INTEGER, name="sunflowers")
hydrangeas = m.addVar(vtype=GRB.INTEGER, name="hydrangeas")
cabbages = m.addVar(vtype=GRB.INTEGER, name="cabbages")

# Set objective function
m.setObjective(5*sunflowers**2 + 8*sunflowers*hydrangeas + 2*sunflowers*cabbages + 7*hydrangeas**2 + 7*hydrangeas*cabbages + 3*cabbages**2 + 3*sunflowers, GRB.MAXIMIZE)

# Add constraints
m.addConstr(22*sunflowers + 19*hydrangeas >= 44, "c1")
m.addConstr((21*hydrangeas)**2 + (2*cabbages)**2 <= 128, "c2")
m.addConstr(9*sunflowers + 21*hydrangeas + 2*cabbages <= 128, "c3")
m.addConstr(22*sunflowers + 19*hydrangeas <= 98, "c4")
m.addConstr(22*sunflowers + 8*cabbages <= 53, "c5")
m.addConstr(22*sunflowers + 19*hydrangeas + 8*cabbages <= 127, "c6")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('sunflowers:', sunflowers.x)
    print('hydrangeas:', hydrangeas.x)
    print('cabbages:', cabbages.x)
elif m.status == GRB.INFEASIBLE:
    print('Model is infeasible')
else:
    print('Optimization ended with status %d' % m.status)

