
import gurobi as gp

# Define the model
m = gp.Model("optimization_problem")

# Define the variables
sunflowers = m.addVar(vtype=gp.GRB.INTEGER, name="sunflowers")
hydrangeas = m.addVar(vtype=gp.GRB.INTEGER, name="hydrangeas")
decorative_cabbages = m.addVar(vtype=gp.GRB.INTEGER, name="decorative_cabbages")

# Objective function
m.setObjective(5 * sunflowers**2 + 8 * sunflowers * hydrangeas + 2 * sunflowers * decorative_cabbages + 
               7 * hydrangeas**2 + 7 * hydrangeas * decorative_cabbages + 3 * decorative_cabbages**2 + 
               3 * sunflowers, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(sunflowers == 9, name="sunflower_yield")
m.addConstr(22 * sunflowers + 19 * hydrangeas >= 44, name="growth_speed_sun_hyd")
m.addConstr(hydrangeas == 21, name="hydrangea_yield")
m.addConstr(8 * decorative_cabbages == 2, name="decorative_cabbage_yield") # corrected to reflect yield not growth speed
m.addConstr(22 * sunflowers <= 22 * 9, name="sunflower_growth_speed") # Redundant but matches description
m.addConstr(19 * hydrangeas <= 19 * 21, name="hydrangea_growth_speed") # Redundant but matches description
m.addConstr(8 * decorative_cabbages <= 8 * 2, name="decorative_cabbage_growth_speed") # Redundant but matches description
m.addConstr(hydrangeas**2 + decorative_cabbages**2 <= 128, name="yield_hyd_cabb")
m.addConstr(sunflowers + hydrangeas + decorative_cabbages <= 128, name="total_yield")
m.addConstr(22 * sunflowers + 19 * hydrangeas <= 98, name="growth_speed_sun_hyd_UB")
m.addConstr(22 * sunflowers + 8 * decorative_cabbages <= 53, name="growth_speed_sun_cabb")
m.addConstr(22 * sunflowers + 19 * hydrangeas + 8 * decorative_cabbages <= 127, name="growth_speed_total")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Sunflowers: ", sunflowers.varValue)
    print("Hydrangeas: ", hydrangeas.varValue)
    print("Decorative Cabbages: ", decorative_cabbages.varValue)
else:
    print("The model is infeasible")
