
from gurobipy import Model, GRB

# Create a new model
model = Model("optimize_work_hours")

# Create variables
hank_hours = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="hank_hours")
laura_hours = model.addVar(lb=0, vtype=GRB.INTEGER, name="laura_hours")
mary_hours = model.addVar(lb=0, vtype=GRB.INTEGER, name="mary_hours")
peggy_hours = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="peggy_hours")

# Set objective function
model.setObjective(9.66 * hank_hours**2 + 2.25 * hank_hours * laura_hours + 5.78 * hank_hours * mary_hours + 9.13 * hank_hours * peggy_hours + 7.01 * laura_hours**2 + 4.14 * mary_hours**2 + 3.29 * peggy_hours**2 + 8.94 * mary_hours, GRB.MINIMIZE)

# Add constraints
model.addConstr(12 * hank_hours + 7 * mary_hours >= 32, "c0")
model.addConstr(11 * laura_hours + 7 * mary_hours >= 17, "c1")
model.addConstr(11 * laura_hours + 4 * peggy_hours >= 21, "c2")
model.addConstr(12 * hank_hours + 11 * laura_hours + 7 * mary_hours >= 40, "c3")
model.addConstr(12 * hank_hours + 11 * laura_hours + 7 * mary_hours + 4 * peggy_hours >= 40, "c4")

model.addConstr(16 * hank_hours + 14 * mary_hours >= 47, "c5")
model.addConstr(14 * mary_hours**2 + 13 * peggy_hours**2 >= 56, "c6")
model.addConstr(19 * laura_hours**2 + 14 * mary_hours**2 >= 22, "c7")
model.addConstr(19 * laura_hours + 13 * peggy_hours >= 32, "c8")
model.addConstr(16 * hank_hours + 19 * laura_hours >= 36, "c9")
model.addConstr(16 * hank_hours + 13 * peggy_hours >= 20, "c10")
model.addConstr(16 * hank_hours + 19 * laura_hours + 14 * mary_hours + 13 * peggy_hours >= 20, "c11")

model.addConstr(-2 * mary_hours + 6 * peggy_hours >= 0, "c12")
model.addConstr(-8 * laura_hours**2 + 7 * mary_hours**2 >= 0, "c13")
model.addConstr(10 * hank_hours**2 - 8 * peggy_hours**2 >= 0, "c14")

model.addConstr(11 * laura_hours**2 + 7 * mary_hours**2 <= 184, "c15")
model.addConstr(12 * hank_hours + 4 * peggy_hours <= 103, "c16")
model.addConstr(12 * hank_hours + 11 * laura_hours <= 52, "c17")
model.addConstr(11 * laura_hours + 4 * peggy_hours <= 146, "c18")
model.addConstr(12 * hank_hours**2 + 11 * laura_hours**2 + 4 * peggy_hours**2 <= 125, "c19")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    print('Hank Hours:', hank_hours.x)
    print('Laura Hours:', laura_hours.x)
    print('Mary Hours:', mary_hours.x)
    print('Peggy Hours:', peggy_hours.x)
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")
