
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define variables
H = m.addVar(lb=-gp.GRB.INFINITY, ub=gp.GRB.INFINITY, name="H")  # Fractional
L = m.addVar(lb=-gp.GRB.INFINITY, ub=gp.GRB.INFINITY, name="L", vtype=gp.GRB.INTEGER)  # Integer
M = m.addVar(lb=-gp.GRB.INFINITY, ub=gp.GRB.INFINITY, name="M", vtype=gp.GRB.INTEGER)  # Integer
P = m.addVar(lb=-gp.GRB.INFINITY, ub=gp.GRB.INFINITY, name="P")  # Fractional

# Objective function
m.setObjective(9.66 * H**2 + 2.25 * H * L + 5.78 * H * M + 9.13 * H * P + 
               7.01 * L**2 + 4.14 * M**2 + 3.29 * P**2 + 8.94 * M, gp.GRB.MINIMIZE)

# Constraints
m.addConstr(12 * H <= 184, name="H_paperwork")
m.addConstr(16 * H <= 229, name="H_quit")
m.addConstr(11 * L <= 184, name="L_paperwork")
m.addConstr(19 * L <= 229, name="L_quit")
m.addConstr(7 * M <= 184, name="M_paperwork")
m.addConstr(14 * M <= 229, name="M_quit")
m.addConstr(4 * P <= 184, name="P_paperwork")
m.addConstr(13 * P <= 229, name="P_quit")

m.addConstr(12 * H + 7 * M >= 32, name="H_M_paperwork")
m.addConstr(11 * L + 7 * M >= 17, name="L_M_paperwork")
m.addConstr(11 * L + 4 * P >= 21, name="L_P_paperwork")
m.addConstr(12 * H + 11 * L + 7 * M >= 40, name="H_L_M_paperwork")
m.addConstr(12 * H + 11 * L + 7 * M + 4 * P >= 40, name="all_paperwork")

m.addConstr(16 * H + 14 * M >= 47, name="H_M_quit")
m.addConstr(14 * M**2 + 13 * P**2 >= 56, name="M_P_quit")
m.addConstr(19 * L**2 + 14 * M**2 >= 22, name="L_M_quit")
m.addConstr(19 * L + 13 * P >= 32, name="L_P_quit")
m.addConstr(16 * H + 19 * L >= 36, name="H_L_quit")
m.addConstr(16 * H + 13 * P >= 20, name="H_P_quit")
m.addConstr(16 * H + 19 * L + 14 * M + 13 * P >= 20, name="all_quit")

m.addConstr(-2 * M + 6 * P >= 0, name="M_P_relationship")
m.addConstr(-8 * L**2 + 7 * M**2 >= 0, name="L_M_relationship")
m.addConstr(10 * H**2 - 8 * P**2 >= 0, name="H_P_relationship")

m.addConstr(11 * L**2 + 7 * M**2 <= 184, name="paperwork_limit")
m.addConstr(12 * H + 4 * P <= 103, name="H_P_limit")
m.addConstr(12 * H + 11 * L <= 52, name="H_L_limit")
m.addConstr(11 * L + 4 * P <= 146, name="L_P_limit")
m.addConstr(12 * H**2 + 11 * L**2 + 4 * P**2 <= 125, name="paperwork_limit_squared")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("H: ", H.varValue)
    print("L: ", L.varValue)
    print("M: ", M.varValue)
    print("P: ", P.varValue)
else:
    print("No optimal solution found")
