
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
milkshakes = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="milkshakes")
cherry_pies = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="cherry_pies")
ravioli = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="ravioli")
bananas = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bananas")

# Set objective function
m.setObjective(2 * milkshakes + 8 * cherry_pies + 5 * ravioli + 7 * bananas, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(10 * cherry_pies + 3 * bananas >= 44, "c1")
m.addConstr(10 * cherry_pies + 23 * ravioli >= 20, "c2")
m.addConstr(22 * milkshakes + 23 * ravioli >= 32, "c3")
m.addConstr(22 * milkshakes + 3 * bananas >= 28, "c4")
m.addConstr(22 * milkshakes + 10 * cherry_pies + 23 * ravioli + 3 * bananas >= 28, "c5")
m.addConstr(2 * milkshakes + 11 * ravioli >= 17, "c6")
m.addConstr(9 * cherry_pies + 12 * bananas >= 20, "c7")
m.addConstr(2 * milkshakes + 9 * cherry_pies >= 25, "c8")
m.addConstr(11 * ravioli + 12 * bananas >= 16, "c9")
m.addConstr(9 * cherry_pies + 11 * ravioli + 12 * bananas >= 27, "c10")
m.addConstr(2 * milkshakes + 9 * cherry_pies + 11 * ravioli + 12 * bananas >= 27, "c11")
m.addConstr(10 * ravioli - 8 * bananas >= 0, "c12")
m.addConstr(milkshakes - 3 * cherry_pies >= 0, "c13")

m.addConstr(23 * ravioli + 3 * bananas <= 163, "c14")
m.addConstr(10 * cherry_pies + 23 * ravioli <= 203, "c15")
m.addConstr(22 * milkshakes + 3 * bananas <= 62, "c16")
m.addConstr(2 * milkshakes + 11 * ravioli + 12 * bananas <= 44, "c17")


# Resource Constraints
m.addConstr(22 * milkshakes + 10 * cherry_pies + 23 * ravioli + 3 * bananas <= 210, "umami_limit")
m.addConstr(2 * milkshakes + 9 * cherry_pies + 11 * ravioli + 12 * bananas <= 138, "carb_limit")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

