
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
milkshakes = m.addVar(lb=0, name="milkshakes", vtype=gp.GRB.CONTINUOUS)
cherry_pies = m.addVar(lb=0, name="cherry_pies", vtype=gp.GRB.CONTINUOUS)
ravioli = m.addVar(lb=0, name="ravioli", vtype=gp.GRB.CONTINUOUS)
bananas = m.addVar(lb=0, name="bananas", vtype=gp.GRB.CONTINUOUS)

# Define the objective function
m.setObjective(2 * milkshakes + 8 * cherry_pies + 5 * ravioli + 7 * bananas, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(22 * milkshakes + 10 * cherry_pies + 23 * ravioli + 3 * bananas <= 210, "umami_index")
m.addConstr(2 * milkshakes + 9 * cherry_pies + 11 * ravioli + 12 * bananas <= 138, "carbohydrates")

m.addConstr(10 * cherry_pies + 3 * bananas >= 44, "cherry_pies_bananas_umami")
m.addConstr(10 * cherry_pies + 23 * ravioli >= 20, "cherry_pies_ravioli_umami")
m.addConstr(22 * milkshakes + 23 * ravioli >= 32, "milkshakes_ravioli_umami")
m.addConstr(22 * milkshakes + 3 * bananas >= 28, "milkshakes_bananas_umami")
m.addConstr(22 * milkshakes + 10 * cherry_pies + 23 * ravioli + 3 * bananas >= 28, "all_umami")

m.addConstr(2 * milkshakes + 11 * ravioli >= 17, "milkshakes_ravioli_carbohydrates")
m.addConstr(9 * cherry_pies + 12 * bananas >= 20, "cherry_pies_bananas_carbohydrates")
m.addConstr(2 * milkshakes + 9 * cherry_pies >= 25, "milkshakes_cherry_pies_carbohydrates")
m.addConstr(11 * ravioli + 12 * bananas >= 16, "ravioli_bananas_carbohydrates")
m.addConstr(9 * cherry_pies + 11 * ravioli + 12 * bananas >= 27, "cherry_pies_ravioli_bananas_carbohydrates")
m.addConstr(2 * milkshakes + 9 * cherry_pies + 11 * ravioli + 12 * bananas >= 27, "all_carbohydrates")

m.addConstr(10 * ravioli - 8 * bananas >= 0, "ravioli_bananas_constraint")
m.addConstr(milkshakes - 3 * cherry_pies >= 0, "milkshakes_cherry_pies_constraint")

m.addConstr(23 * ravioli + 3 * bananas <= 163, "ravioli_bananas_umami_max")
m.addConstr(10 * cherry_pies + 23 * ravioli <= 203, "cherry_pies_ravioli_umami_max")
m.addConstr(22 * milkshakes + 3 * bananas <= 62, "milkshakes_bananas_umami_max")
m.addConstr(2 * milkshakes + 11 * ravioli + 12 * bananas <= 44, "milkshakes_ravioli_bananas_carbohydrates_max")

# Solve the problem
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Milkshakes: {milkshakes.varValue}")
    print(f"Cherry pies: {cherry_pies.varValue}")
    print(f"Ravioli: {ravioli.varValue}")
    print(f"Bananas: {bananas.varValue}")
    print(f"Objective: {m.objVal}")
else:
    print("No optimal solution found.")
