
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define variables
calcium = m.addVar(lb=0, name="milligrams_of_calcium")
protein = m.addVar(lb=0, name="grams_of_protein")
vitamin_b9 = m.addVar(lb=0, name="milligrams_of_vitamin_B9")

# Objective function: Maximize
m.setObjective(9*calcium + 2*protein + 8*vitamin_b9, GRB.MAXIMIZE)

# Constraints
m.addConstr(protein * 6.48 + vitamin_b9 * 3.53 >= 47, name="constraint_1")
m.addConstr(calcium * 7.69 + protein * 6.48 + vitamin_b9 * 3.53 >= 64, name="constraint_2")
m.addConstr(protein * 6.48 + vitamin_b9 * 3.53 <= 157, name="constraint_3")
m.addConstr(calcium * 7.69 + vitamin_b9 * 3.53 <= 158, name="constraint_4")
m.addConstr(calcium * 7.69 + protein * 6.48 <= 192, name="constraint_5")
m.addConstr(calcium * 7.69 + protein * 6.48 + vitamin_b9 * 3.53 <= 192, name="constraint_6")

# Solve the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Milligrams of Calcium: {calcium.x}")
    print(f"Grams of Protein: {protein.x}")
    print(f"Milligrams of Vitamin B9: {vitamin_b9.x}")
    print(f"Objective Function Value: {m.objVal}")
else:
    print("No optimal solution found")
