
import gurobipy as gp

# Create a new model
m = gp.Model("WorkOptimization")

# Create variables
bill_hours = m.addVar(lb=0, name="bill_hours")
john_hours = m.addVar(lb=0, name="john_hours")
laura_hours = m.addVar(lb=0, name="laura_hours")
jean_hours = m.addVar(lb=0, name="jean_hours")

# Set objective function
m.setObjective(7.73 * bill_hours + 6.89 * john_hours + 8.6 * laura_hours + 6.81 * jean_hours, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(9 * john_hours + 14 * laura_hours >= 38, "c1")
m.addConstr(9 * bill_hours + 13 * jean_hours >= 24, "c2")
m.addConstr(9 * bill_hours + 8 * john_hours >= 43, "c3")
m.addConstr(9 * bill_hours + 8 * john_hours + 14 * laura_hours + 13 * jean_hours >= 43, "c4")
m.addConstr(-1 * bill_hours + 2 * john_hours >= 0, "c5")
m.addConstr(-6 * bill_hours + 8 * laura_hours >= 0, "c6")
m.addConstr(8 * john_hours + 14 * laura_hours <= 174, "c7")
m.addConstr(9 * bill_hours + 13 * jean_hours <= 121, "c8")
m.addConstr(9 * bill_hours + 8 * john_hours <= 119, "c9")
m.addConstr(8 * john_hours + 13 * jean_hours <= 118, "c10")
m.addConstr(9 * bill_hours + 8 * john_hours + 14 * laura_hours <= 72, "c11")
m.addConstr(9 * bill_hours + 8 * john_hours + 13 * jean_hours <= 100, "c12")
m.addConstr(8 * john_hours + 14 * laura_hours + 13 * jean_hours <= 173, "c13")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Optimal objective: %g' % m.objVal)
    print('Bill hours: %g' % bill_hours.x)
    print('John hours: %g' % john_hours.x)
    print('Laura hours: %g' % laura_hours.x)
    print('Jean hours: %g' % jean_hours.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)
