
import gurobi as gp

# Define the model
m = gp.Model("Work_Optimization")

# Define the variables
hours_worked_by_Bill = m.addVar(name="hours_worked_by_Bill", lb=0)  # No upper bound specified, so lb=0
hours_worked_by_John = m.addVar(name="hours_worked_by_John", lb=0)
hours_worked_by_Laura = m.addVar(name="hours_worked_by_Laura", lb=0)
hours_worked_by_Jean = m.addVar(name="hours_worked_by_Jean", lb=0)

# Objective function
m.setObjective(7.73 * hours_worked_by_Bill + 6.89 * hours_worked_by_John + 8.6 * hours_worked_by_Laura + 6.81 * hours_worked_by_Jean, gp.GRB.MINIMIZE)

# Constraints
# Individual work quality ratings
m.addConstr(9 * hours_worked_by_Bill <= 9 * hours_worked_by_Bill)  # This constraint is always true
m.addConstr(8 * hours_worked_by_John <= 8 * hours_worked_by_John)  # This constraint is always true
m.addConstr(14 * hours_worked_by_Laura <= 14 * hours_worked_by_Laura)  # This constraint is always true
m.addConstr(13 * hours_worked_by_Jean <= 13 * hours_worked_by_Jean)  # This constraint is always true

# Combined work quality rating constraints
m.addConstr(8 * hours_worked_by_John + 14 * hours_worked_by_Laura >= 38)
m.addConstr(9 * hours_worked_by_Bill + 13 * hours_worked_by_Jean >= 24)
m.addConstr(9 * hours_worked_by_Bill + 8 * hours_worked_by_John >= 43)
m.addConstr(9 * hours_worked_by_Bill + 8 * hours_worked_by_John + 14 * hours_worked_by_Laura + 13 * hours_worked_by_Jean >= 43)

# Other constraints
m.addConstr(-1 * hours_worked_by_Bill + 2 * hours_worked_by_John >= 0)
m.addConstr(-6 * hours_worked_by_Bill + 8 * hours_worked_by_Laura >= 0)

# Upper bounds on combined work quality ratings
m.addConstr(8 * hours_worked_by_John + 14 * hours_worked_by_Laura <= 174)
m.addConstr(9 * hours_worked_by_Bill + 13 * hours_worked_by_Jean <= 121)
m.addConstr(9 * hours_worked_by_Bill + 8 * hours_worked_by_John <= 119)
m.addConstr(8 * hours_worked_by_John + 13 * hours_worked_by_Jean <= 118)
m.addConstr(9 * hours_worked_by_Bill + 8 * hours_worked_by_John + 14 * hours_worked_by_Laura <= 72)
m.addConstr(9 * hours_worked_by_Bill + 8 * hours_worked_by_John + 13 * hours_worked_by_Jean <= 100)
m.addConstr(8 * hours_worked_by_John + 14 * hours_worked_by_Laura + 13 * hours_worked_by_Jean <= 173)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Hours worked by Bill: {hours_worked_by_Bill.varValue}")
    print(f"Hours worked by John: {hours_worked_by_John.varValue}")
    print(f"Hours worked by Laura: {hours_worked_by_Laura.varValue}")
    print(f"Hours worked by Jean: {hours_worked_by_Jean.varValue}")
    print(f"Objective: {m.objVal}")
else:
    print("No optimal solution found.")
