
from gurobipy import *

try:

    # Create a new model
    model = Model("optimization_model")

    # Create variables
    fiber = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="fiber")
    carbs = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="carbs")
    iron = model.addVar(lb=0, vtype=GRB.INTEGER, name="iron")
    vitamin_b2 = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="vitamin_b2")
    potassium = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="potassium")

    # Set objective
    obj = 8*fiber*fiber + 4*fiber*carbs + fiber*vitamin_b2 + 7*fiber*potassium + 6*carbs*carbs + 6*carbs*vitamin_b2 + 7*carbs*potassium + 4*iron*iron + 7*iron*vitamin_b2 + iron*potassium + 4*vitamin_b2*potassium + 3*potassium*potassium + 8*fiber + 7*iron + 3*potassium
    model.setObjective(obj, GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(1*fiber + 11*carbs + 15*iron + 22*vitamin_b2 + 5*potassium <= 263, "immune_support_index") # Resource constraint r0
    model.addConstr(14*fiber + 18*carbs + 4*iron + 11*vitamin_b2 + 20*potassium <= 332, "energy_stability_index") # Resource constraint r1

    model.addConstr(11*carbs + 15*iron >= 33, "c1")
    model.addConstr(15*iron*iron + 22*vitamin_b2*vitamin_b2 >= 42, "c2")
    model.addConstr(fiber + 11*carbs >= 43, "c3")
    model.addConstr(18*carbs + 4*iron >= 64, "c4")
    model.addConstr(14*fiber + 4*iron >= 61, "c5")
    model.addConstr(14*fiber + 11*vitamin_b2 >= 34, "c6")
    model.addConstr(14*fiber*fiber + 20*potassium*potassium >= 25, "c7")
    model.addConstr(4*iron + 20*potassium >= 49, "c8")
    model.addConstr(18*carbs + 11*vitamin_b2 >= 60, "c9")
    model.addConstr(-9*fiber*fiber + 9*carbs*carbs + 5*potassium*potassium >= 0, "c10")
    model.addConstr(22*vitamin_b2 + 5*potassium <= 147, "c11")
    model.addConstr(15*iron*iron + 5*potassium*potassium <= 142, "c12")
    model.addConstr(fiber*fiber + 5*potassium*potassium <= 258, "c13")
    model.addConstr(fiber*fiber + 22*vitamin_b2*vitamin_b2 <= 97, "c14")
    model.addConstr(11*carbs + 5*potassium <= 131, "c15")
    model.addConstr(fiber + 22*vitamin_b2 + 5*potassium <= 67, "c16")
    model.addConstr(fiber + 11*carbs + 5*potassium <= 56, "c17")
    model.addConstr(15*iron*iron + 22*vitamin_b2*vitamin_b2 + 5*potassium*potassium <= 205, "c18")
    model.addConstr(fiber + 11*carbs + 15*iron + 22*vitamin_b2 + 5*potassium <= 205, "c19")
    model.addConstr(4*iron + 11*vitamin_b2 <= 160, "c20")
    model.addConstr(14*fiber + 4*iron <= 201, "c21")
    model.addConstr(11*vitamin_b2*vitamin_b2 + 20*potassium*potassium <= 108, "c22")
    model.addConstr(18*carbs + 4*iron + 20*potassium <= 322, "c23")
    model.addConstr(14*fiber + 18*carbs + 11*vitamin_b2 <= 67, "c24")
    model.addConstr(14*fiber + 18*carbs + 4*iron + 11*vitamin_b2 + 20*potassium <= 67, "c25")


    # Optimize model
    model.optimize()

    if model.status == GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        for v in model.getVars():
            print('%s %g' % (v.varName, v.x))
    elif model.status == GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print("Optimization ended with status:", model.status)


except GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
