
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
x0 = m.addVar(lb=0, name="grams_of_fiber")  # Continuous
x1 = m.addVar(lb=0, name="grams_of_carbohydrates")  # Continuous
x2 = m.addVar(lb=0, type=gp.GRB.INTEGER, name="milligrams_of_iron")  # Integer
x3 = m.addVar(lb=0, name="milligrams_of_vitamin_B2")  # Continuous
x4 = m.addVar(lb=0, name="milligrams_of_potassium")  # Continuous

# Objective function
m.setObjective(8*x0**2 + 4*x0*x1 + x0*x3 + 7*x0*x4 + 6*x1**2 + 6*x1*x3 + 7*x1*x4 + 
               4*x2**2 + 7*x2*x3 + x2*x4 + 4*x3*x4 + 3*x4**2 + 8*x0 + 7*x2 + 3*x4, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(1*x0 + 11*x1 + 15*x2 + 22*x3 + 5*x4 <= 263, "immune_support_index")
m.addConstr(11*x1 + 15*x2 >= 33, "immune_support_index_2")
m.addConstr(15*x2**2 + 22*x3**2 >= 42, "immune_support_index_3")
m.addConstr(1*x0 + 11*x1 >= 43, "immune_support_index_4")
m.addConstr(14*x0 + 18*x1 + 4*x2 + 11*x3 + 20*x4 <= 332, "energy_stability_index")
m.addConstr(14*x0 + 4*x2 >= 61, "energy_stability_index_2")
m.addConstr(14*x0 + 11*x3 >= 34, "energy_stability_index_3")
m.addConstr(14*x0**2 + 20*x4**2 >= 25, "energy_stability_index_4")
m.addConstr(4*x2 + 20*x4 >= 49, "energy_stability_index_5")
m.addConstr(18*x1 + 11*x3 >= 60, "energy_stability_index_6")
m.addConstr(-9*x0**2 + 9*x1**2 + 5*x4**2 >= 0, "energy_stability_index_7")
m.addConstr(11*x3 + 5*x4 <= 147, "immune_support_index_8")
m.addConstr(15*x2**2 + 5*x4**2 <= 142, "immune_support_index_9")
m.addConstr(1*x0**2 + 5*x4**2 <= 258, "immune_support_index_10")
m.addConstr(1*x0**2 + 22*x3**2 <= 97, "immune_support_index_11")
m.addConstr(11*x1 + 5*x4 <= 131, "immune_support_index_12")
m.addConstr(1*x0 + 22*x3 + 5*x4 <= 67, "immune_support_index_13")
m.addConstr(1*x0 + 11*x1 + 5*x4 <= 56, "immune_support_index_14")
m.addConstr(15*x2**2 + 22*x3**2 + 5*x4**2 <= 205, "immune_support_index_15")
m.addConstr(1*x0 + 11*x1 + 15*x2 + 22*x3 + 5*x4 <= 205, "immune_support_index_16")
m.addConstr(4*x2 + 11*x3 <= 160, "energy_stability_index_8")
m.addConstr(14*x0 + 4*x2 <= 201, "energy_stability_index_9")
m.addConstr(11*x3**2 + 20*x4**2 <= 108, "energy_stability_index_10")
m.addConstr(18*x1 + 4*x2 + 20*x4 <= 322, "energy_stability_index_11")
m.addConstr(14*x0 + 18*x1 + 11*x3 <= 67, "energy_stability_index_12")
m.addConstr(14*x0 + 18*x1 + 4*x2 + 11*x3 + 20*x4 <= 67, "energy_stability_index_13")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Grams of fiber: ", x0.varValue)
    print("Grams of carbohydrates: ", x1.varValue)
    print("Milligrams of iron: ", x2.varValue)
    print("Milligrams of vitamin B2: ", x3.varValue)
    print("Milligrams of potassium: ", x4.varValue)
else:
    print("The model is infeasible or unbounded.")
