
from gurobipy import Model, GRB

# Create a new model
model = Model("fruit_optimization")

# Create variables
kiwis = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="kiwis")
strawberries = model.addVar(lb=0, vtype=GRB.INTEGER, name="strawberries")

# Set objective function
model.setObjective(kiwis**2 + 3*kiwis*strawberries + 7*strawberries**2 + 9*kiwis + 3*strawberries, GRB.MINIMIZE)

# Add constraints
model.addConstr(1.97 * kiwis + 4.63 * strawberries >= 71, "tastiness_min")
model.addConstr(1.97 * kiwis + 4.63 * strawberries <= 138, "tastiness_max") # corrected upper bound constraint
model.addConstr(8 * kiwis**2 - 8 * strawberries**2 >= 0, "kiwi_strawberry_relation")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal solution found:")
    print(f"  Kiwis: {kiwis.x}")
    print(f"  Strawberries: {strawberries.x}")
    print(f"  Objective value: {model.objVal}")
elif model.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

