
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x0 = m.addVar(lb=0, ub=GRB.INFINITY, vtype=GRB.CONTINUOUS, name="kiwis")
x1 = m.addVar(lb=0, ub=GRB.INFINITY, vtype=GRB.INTEGER, name="strawberries")

# Objective function
m.setObjective(1*x0**2 + 3*x0*x1 + 7*x1**2 + 9*x0 + 3*x1, GRB.MINIMIZE)

# Constraints
m.addConstr(1.97*x0 + 4.63*x1 >= 71, name="min_tastiness")
m.addConstr(1.97*x0 + 4.63*x1 <= 138, name="max_tastiness")
m.addConstr(8*x0**2 - 8*x1**2 >= 0, name="additional_constraint")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Kiwis: {x0.x}")
    print(f"Strawberries: {x1.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
