
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define variables
kiwis = m.addVar(lb=-gp.GRB.INFINITY, name="kiwis")  # No lower bound specified, assuming can be negative
strawberries = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="strawberries")  # Must be a whole number

# Objective function
m.setObjective(kiwis**2 + 3*kiwis*strawberries + 7*strawberries**2 + 9*kiwis + 3*strawberries, gp.GRB.MINIMIZE)

# Constraints
tastiness_kiwi = 1.97
tastiness_strawberry = 4.63

m.addConstr(tastiness_kiwi * kiwis + tastiness_strawberry * strawberries >= 71, name="min_tastiness")
m.addConstr(tastiness_kiwi * kiwis + tastiness_strawberry * strawberries <= 138, name="max_tastiness")
m.addConstr(8 * kiwis**2 - 8 * strawberries**2 >= 0, name="quadratic_constraint")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Kiwis: {kiwis.varValue}")
    print(f"Strawberries: {strawberries.varValue}")
    print(f"Objective: {m.objVal}")
else:
    print("No optimal solution found.")
