
import gurobipy as gp

# Create a new model
m = gp.Model("office_supplies")

# Create variables
yellow_highlighters = m.addVar(vtype=gp.GRB.INTEGER, name="yellow_highlighters")
paper_clips = m.addVar(vtype=gp.GRB.INTEGER, name="paper_clips")
packs_of_paper = m.addVar(vtype=gp.GRB.INTEGER, name="packs_of_paper")
manila_envelopes = m.addVar(vtype=gp.GRB.INTEGER, name="manila_envelopes")

# Set objective function
m.setObjective(5 * yellow_highlighters + 8 * paper_clips + 4 * packs_of_paper + 2 * manila_envelopes, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(6 * paper_clips + 5 * manila_envelopes >= 23, "c0")
m.addConstr(9 * yellow_highlighters + 6 * paper_clips >= 17, "c1")
m.addConstr(6 * paper_clips + 7 * packs_of_paper >= 30, "c2")
m.addConstr(9 * yellow_highlighters + 7 * packs_of_paper >= 25, "c3")
m.addConstr(9 * yellow_highlighters + 6 * paper_clips + 7 * packs_of_paper + 5 * manila_envelopes >= 25, "c4")
m.addConstr(10 * paper_clips + 2 * packs_of_paper >= 16, "c5")
m.addConstr(8 * yellow_highlighters + 10 * paper_clips >= 15, "c6")
m.addConstr(2 * packs_of_paper + 8 * manila_envelopes >= 10, "c7")
m.addConstr(10 * paper_clips + 8 * manila_envelopes >= 14, "c8")
m.addConstr(8 * yellow_highlighters + 2 * packs_of_paper >= 24, "c9")
m.addConstr(8 * yellow_highlighters + 10 * paper_clips + 2 * packs_of_paper + 8 * manila_envelopes >= 24, "c10")
m.addConstr(3 * paper_clips - packs_of_paper >= 0, "c11")
m.addConstr(4 * yellow_highlighters - paper_clips >= 0, "c12")
m.addConstr(6 * paper_clips + 7 * packs_of_paper <= 105, "c13")
m.addConstr(6 * paper_clips + 7 * packs_of_paper + 5 * manila_envelopes <= 126, "c14")
m.addConstr(9 * yellow_highlighters + 6 * paper_clips + 7 * packs_of_paper <= 59, "c15")
m.addConstr(9 * yellow_highlighters + 7 * packs_of_paper + 5 * manila_envelopes <= 61, "c16")
m.addConstr(8 * yellow_highlighters + 8 * manila_envelopes <= 70, "c17")
m.addConstr(8 * yellow_highlighters + 10 * paper_clips + 2 * packs_of_paper <= 72, "c18")
m.addConstr(10 * paper_clips + 2 * packs_of_paper + 8 * manila_envelopes <= 79, "c19")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

