
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name="yellow_highlighters", vtype=gurobi.GRB.INTEGER)
    x1 = model.addVar(name="paper_clips", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="packs_of_paper", vtype=gurobi.GRB.INTEGER)
    x3 = model.addVar(name="manila_envelopes", vtype=gurobi.GRB.INTEGER)

    # Objective function
    model.setObjective(5 * x0 + 8 * x1 + 4 * x2 + 2 * x3, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(9 * x0 + 6 * x1 + 7 * x2 + 5 * x3 <= 132, name="workplace_safety_impact")
    model.addConstr(8 * x0 + 10 * x1 + 2 * x2 + 8 * x3 <= 115, name="employee_satisfaction_impact")

    model.addConstr(6 * x1 + 5 * x3 >= 23, name="safety_paper_clips_envelopes")
    model.addConstr(9 * x0 + 6 * x1 >= 17, name="safety_highlighters_paper_clips")
    model.addConstr(6 * x1 + 7 * x2 >= 30, name="safety_paper_clips_packs_paper")
    model.addConstr(9 * x0 + 7 * x2 >= 25, name="safety_highlighters_packs_paper")
    model.addConstr(9 * x0 + 6 * x1 + 7 * x2 + 5 * x3 >= 25, name="safety_all")

    model.addConstr(10 * x1 + 2 * x2 >= 16, name="satisfaction_paper_clips_packs_paper")
    model.addConstr(8 * x0 + 10 * x1 >= 15, name="satisfaction_highlighters_paper_clips")
    model.addConstr(2 * x2 + 8 * x3 >= 10, name="satisfaction_packs_paper_envelopes")
    model.addConstr(10 * x1 + 8 * x3 >= 14, name="satisfaction_paper_clips_envelopes")
    model.addConstr(8 * x0 + 2 * x2 >= 24, name="satisfaction_highlighters_packs_paper")
    model.addConstr(8 * x0 + 10 * x1 + 2 * x2 + 8 * x3 >= 24, name="satisfaction_all")

    model.addConstr(3 * x1 - x2 >= 0, name="paper_clips_packs_paper")
    model.addConstr(4 * x0 - x1 >= 0, name="highlighters_paper_clips")

    model.addConstr(6 * x1 + 7 * x2 <= 105, name="safety_paper_clips_packs_paper_limit")
    model.addConstr(6 * x1 + 7 * x2 + 5 * x3 <= 126, name="safety_paper_clips_packs_paper_envelopes_limit")
    model.addConstr(9 * x0 + 6 * x1 + 7 * x2 <= 59, name="safety_highlighters_paper_clips_packs_paper_limit")
    model.addConstr(9 * x0 + 7 * x2 + 5 * x3 <= 61, name="safety_highlighters_packs_paper_envelopes_limit")
    model.addConstr(8 * x0 + 8 * x3 <= 70, name="satisfaction_highlighters_envelopes_limit")
    model.addConstr(8 * x0 + 10 * x1 + 2 * x2 <= 72, name="satisfaction_highlighters_paper_clips_packs_paper_limit")
    model.addConstr(10 * x1 + 2 * x2 + 8 * x3 <= 79, name="satisfaction_paper_clips_packs_paper_envelopes_limit")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("Yellow Highlighters: ", x0.varValue)
        print("Paper Clips: ", x1.varValue)
        print("Packs of Paper: ", x2.varValue)
        print("Manila Envelopes: ", x3.varValue)
    else:
        print("The model is infeasible")

solve_optimization_problem()
