
import gurobipy as gp

# Create a new model
m = gp.Model("nutrition_optimization")

# Create variables
chicken_breasts = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="chicken_breasts")
fruit_salads = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="fruit_salads")
ham_sandwiches = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="ham_sandwiches")

# Set objective function
m.setObjective(6 * chicken_breasts + 3 * fruit_salads + 3 * ham_sandwiches, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(6 * chicken_breasts + 9 * fruit_salads >= 47, "protein_constraint1")
m.addConstr(6 * chicken_breasts + 9 * fruit_salads + 8 * ham_sandwiches >= 47, "protein_constraint2")

m.addConstr(21 * chicken_breasts + 21 * fruit_salads >= 84, "iron_constraint1")
m.addConstr(21 * fruit_salads + 20 * ham_sandwiches >= 33, "iron_constraint2")
m.addConstr(21 * chicken_breasts + 20 * ham_sandwiches >= 37, "iron_constraint3")
m.addConstr(21 * chicken_breasts + 21 * fruit_salads + 20 * ham_sandwiches >= 98, "iron_constraint4")
m.addConstr(21 * chicken_breasts + 21 * fruit_salads + 20 * ham_sandwiches >= 98, "iron_constraint5")


m.addConstr(10 * chicken_breasts + 17 * ham_sandwiches >= 18, "fiber_constraint1")
m.addConstr(19 * fruit_salads + 17 * ham_sandwiches >= 42, "fiber_constraint2")
m.addConstr(10 * chicken_breasts + 19 * fruit_salads + 17 * ham_sandwiches >= 29, "fiber_constraint3")
m.addConstr(10 * chicken_breasts + 19 * fruit_salads + 17 * ham_sandwiches >= 29, "fiber_constraint4")

m.addConstr(6 * chicken_breasts - 5 * ham_sandwiches >= 0, "additional_constraint")

# Resource Constraints
m.addConstr(6 * chicken_breasts + 9 * fruit_salads + 8 * ham_sandwiches <= 234, "protein_limit")
m.addConstr(21 * chicken_breasts + 21 * fruit_salads + 20 * ham_sandwiches <= 303, "iron_limit")
m.addConstr(10 * chicken_breasts + 19 * fruit_salads + 17 * ham_sandwiches <= 126, "fiber_limit")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

