
import gurobi

# Define the model
model = gurobi.Model()

# Define the variables
x0 = model.addVar(name="chicken_breasts", lb=0)  # chicken breasts
x1 = model.addVar(name="fruit_salads", lb=0)    # fruit salads
x2 = model.addVar(name="ham_sandwiches", lb=0)  # ham sandwiches

# Objective function: minimize 6*x0 + 3*x1 + 3*x2
model.setObjective(6*x0 + 3*x1 + 3*x2, gurobi.GRB.MINIMIZE)

# Constraints
# Protein constraints
model.addConstr(6*x0 + 9*x1 >= 47, name="protein_chicken_fruit")
model.addConstr(6*x0 + 9*x1 + 8*x2 >= 47, name="protein_all")

# Iron constraints
model.addConstr(21*x0 + 21*x1 >= 84, name="iron_chicken_fruit")
model.addConstr(21*x1 + 20*x2 >= 33, name="iron_fruit_ham")
model.addConstr(21*x0 + 20*x2 >= 37, name="iron_chicken_ham")
model.addConstr(21*x0 + 21*x1 + 20*x2 >= 98, name="iron_all")

# Fiber constraints
model.addConstr(10*x0 + 17*x2 >= 18, name="fiber_chicken_ham")
model.addConstr(19*x1 + 17*x2 >= 42, name="fiber_fruit_ham")
model.addConstr(10*x0 + 19*x1 + 17*x2 >= 29, name="fiber_all")

# Additional constraint
model.addConstr(6*x0 - 5*x2 >= 0, name="additional_constraint")

# Solve the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", model.objval)
    print("Chicken breasts: ", x0.x)
    print("Fruit salads: ", x1.x)
    print("Ham sandwiches: ", x2.x)
else:
    print("The model is infeasible")
