
from gurobipy import Model, GRB

# Create a new model
model = Model("vitamin_optimization")

# Create variables
vitamin_e = model.addVar(vtype=GRB.INTEGER, name="vitamin_e")
vitamin_a = model.addVar(vtype=GRB.INTEGER, name="vitamin_a")
zinc = model.addVar(vtype=GRB.CONTINUOUS, name="zinc")

# Set objective function
model.setObjective(6 * vitamin_e + 3 * vitamin_a + 3 * zinc, GRB.MAXIMIZE)

# Add constraints
model.addConstr(20 * vitamin_a + 16 * zinc >= 33, "digestive_constraint1")
model.addConstr(21 * vitamin_e + 16 * zinc >= 39, "digestive_constraint2")
model.addConstr(2 * vitamin_a + 1 * zinc <= 121, "kidney_constraint1")
model.addConstr(1 * vitamin_e + 2 * vitamin_a + 1 * zinc <= 121, "kidney_constraint2")
model.addConstr(21 * vitamin_e + 16 * zinc <= 133, "digestive_constraint3")
model.addConstr(21 * vitamin_e + 20 * vitamin_a + 16 * zinc <= 133, "digestive_constraint4")
model.addConstr(1 * vitamin_e + 2 * vitamin_a + 1 * zinc <= 296, "kidney_support_index") # Added missing constraint
model.addConstr(21 * vitamin_e + 20 * vitamin_a + 16 * zinc <= 135, "digestive_support_index") # Added missing constraint


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    print('vitamin_e:', vitamin_e.x)
    print('vitamin_a:', vitamin_a.x)
    print('zinc:', zinc.x)
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

